<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderUpdateDto StructType
 * @subpackage Structs
 */
class OrderUpdateDto extends AbstractStructBase
{
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The IntegrationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegrationCode;
    /**
     * The TradingWaybillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TradingWaybillNumber;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceNumber;
    /**
     * Constructor method for OrderUpdateDto
     * @uses OrderUpdateDto::setUserName()
     * @uses OrderUpdateDto::setPassword()
     * @uses OrderUpdateDto::setIntegrationCode()
     * @uses OrderUpdateDto::setTradingWaybillNumber()
     * @uses OrderUpdateDto::setInvoiceNumber()
     * @param string $userName
     * @param string $password
     * @param string $integrationCode
     * @param string $tradingWaybillNumber
     * @param string $invoiceNumber
     */
    public function __construct($userName = null, $password = null, $integrationCode = null, $tradingWaybillNumber = null, $invoiceNumber = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setIntegrationCode($integrationCode)
            ->setTradingWaybillNumber($tradingWaybillNumber)
            ->setInvoiceNumber($invoiceNumber);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\OrderUpdateDto
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\OrderUpdateDto
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get IntegrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->IntegrationCode;
    }
    /**
     * Set IntegrationCode value
     * @param string $integrationCode
     * @return \StructType\OrderUpdateDto
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integrationCode)), __LINE__);
        }
        $this->IntegrationCode = $integrationCode;
        return $this;
    }
    /**
     * Get TradingWaybillNumber value
     * @return string|null
     */
    public function getTradingWaybillNumber()
    {
        return $this->TradingWaybillNumber;
    }
    /**
     * Set TradingWaybillNumber value
     * @param string $tradingWaybillNumber
     * @return \StructType\OrderUpdateDto
     */
    public function setTradingWaybillNumber($tradingWaybillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tradingWaybillNumber) && !is_string($tradingWaybillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tradingWaybillNumber)), __LINE__);
        }
        $this->TradingWaybillNumber = $tradingWaybillNumber;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\OrderUpdateDto
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderUpdateDto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
