<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerAddress StructType
 * @subpackage Structs
 */
class CustomerAddress extends AbstractStructBase
{
    /**
     * The OlusturmaTarihi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OlusturmaTarihi;
    /**
     * The Adres
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adres;
    /**
     * The Sube
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sube;
    /**
     * The Bolge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bolge;
    /**
     * The AddressId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressId;
    /**
     * The AddressIntegrationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressIntegrationCode;
    /**
     * Constructor method for CustomerAddress
     * @uses CustomerAddress::setOlusturmaTarihi()
     * @uses CustomerAddress::setAdres()
     * @uses CustomerAddress::setSube()
     * @uses CustomerAddress::setBolge()
     * @uses CustomerAddress::setAddressId()
     * @uses CustomerAddress::setAddressIntegrationCode()
     * @param string $olusturmaTarihi
     * @param string $adres
     * @param string $sube
     * @param string $bolge
     * @param string $addressId
     * @param string $addressIntegrationCode
     */
    public function __construct($olusturmaTarihi = null, $adres = null, $sube = null, $bolge = null, $addressId = null, $addressIntegrationCode = null)
    {
        $this
            ->setOlusturmaTarihi($olusturmaTarihi)
            ->setAdres($adres)
            ->setSube($sube)
            ->setBolge($bolge)
            ->setAddressId($addressId)
            ->setAddressIntegrationCode($addressIntegrationCode);
    }
    /**
     * Get OlusturmaTarihi value
     * @return string
     */
    public function getOlusturmaTarihi()
    {
        return $this->OlusturmaTarihi;
    }
    /**
     * Set OlusturmaTarihi value
     * @param string $olusturmaTarihi
     * @return \StructType\CustomerAddress
     */
    public function setOlusturmaTarihi($olusturmaTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($olusturmaTarihi) && !is_string($olusturmaTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($olusturmaTarihi)), __LINE__);
        }
        $this->OlusturmaTarihi = $olusturmaTarihi;
        return $this;
    }
    /**
     * Get Adres value
     * @return string|null
     */
    public function getAdres()
    {
        return $this->Adres;
    }
    /**
     * Set Adres value
     * @param string $adres
     * @return \StructType\CustomerAddress
     */
    public function setAdres($adres = null)
    {
        // validation for constraint: string
        if (!is_null($adres) && !is_string($adres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adres)), __LINE__);
        }
        $this->Adres = $adres;
        return $this;
    }
    /**
     * Get Sube value
     * @return string|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param string $sube
     * @return \StructType\CustomerAddress
     */
    public function setSube($sube = null)
    {
        // validation for constraint: string
        if (!is_null($sube) && !is_string($sube)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sube)), __LINE__);
        }
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Get Bolge value
     * @return string|null
     */
    public function getBolge()
    {
        return $this->Bolge;
    }
    /**
     * Set Bolge value
     * @param string $bolge
     * @return \StructType\CustomerAddress
     */
    public function setBolge($bolge = null)
    {
        // validation for constraint: string
        if (!is_null($bolge) && !is_string($bolge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bolge)), __LINE__);
        }
        $this->Bolge = $bolge;
        return $this;
    }
    /**
     * Get AddressId value
     * @return string|null
     */
    public function getAddressId()
    {
        return $this->AddressId;
    }
    /**
     * Set AddressId value
     * @param string $addressId
     * @return \StructType\CustomerAddress
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: string
        if (!is_null($addressId) && !is_string($addressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressId)), __LINE__);
        }
        $this->AddressId = $addressId;
        return $this;
    }
    /**
     * Get AddressIntegrationCode value
     * @return string|null
     */
    public function getAddressIntegrationCode()
    {
        return $this->AddressIntegrationCode;
    }
    /**
     * Set AddressIntegrationCode value
     * @param string $addressIntegrationCode
     * @return \StructType\CustomerAddress
     */
    public function setAddressIntegrationCode($addressIntegrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressIntegrationCode) && !is_string($addressIntegrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressIntegrationCode)), __LINE__);
        }
        $this->AddressIntegrationCode = $addressIntegrationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
