<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressDto StructType
 * @subpackage Structs
 */
class AddressDto extends AbstractStructBase
{
    /**
     * The ImportCargoInfoId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ImportCargoInfoId;
    /**
     * The ReceiverName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverName;
    /**
     * The ReceiverAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAddress;
    /**
     * The ReceiverPhone1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhone1;
    /**
     * The ReceiverPhone2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhone2;
    /**
     * The ReceiverPhone3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhone3;
    /**
     * The ReceiverCityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverCityName;
    /**
     * The ReceiverTownName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverTownName;
    /**
     * The AddressId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressId;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityCode;
    /**
     * The TownCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TownCode;
    /**
     * The ReceiverDistrictName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverDistrictName;
    /**
     * The ReceiverQuarterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverQuarterName;
    /**
     * The ReceiverAvenueName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAvenueName;
    /**
     * The ReceiverStreetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverStreetName;
    /**
     * Constructor method for AddressDto
     * @uses AddressDto::setImportCargoInfoId()
     * @uses AddressDto::setReceiverName()
     * @uses AddressDto::setReceiverAddress()
     * @uses AddressDto::setReceiverPhone1()
     * @uses AddressDto::setReceiverPhone2()
     * @uses AddressDto::setReceiverPhone3()
     * @uses AddressDto::setReceiverCityName()
     * @uses AddressDto::setReceiverTownName()
     * @uses AddressDto::setAddressId()
     * @uses AddressDto::setCountry()
     * @uses AddressDto::setCountryCode()
     * @uses AddressDto::setCityCode()
     * @uses AddressDto::setTownCode()
     * @uses AddressDto::setReceiverDistrictName()
     * @uses AddressDto::setReceiverQuarterName()
     * @uses AddressDto::setReceiverAvenueName()
     * @uses AddressDto::setReceiverStreetName()
     * @param string $importCargoInfoId
     * @param string $receiverName
     * @param string $receiverAddress
     * @param string $receiverPhone1
     * @param string $receiverPhone2
     * @param string $receiverPhone3
     * @param string $receiverCityName
     * @param string $receiverTownName
     * @param string $addressId
     * @param string $country
     * @param string $countryCode
     * @param string $cityCode
     * @param string $townCode
     * @param string $receiverDistrictName
     * @param string $receiverQuarterName
     * @param string $receiverAvenueName
     * @param string $receiverStreetName
     */
    public function __construct($importCargoInfoId = null, $receiverName = null, $receiverAddress = null, $receiverPhone1 = null, $receiverPhone2 = null, $receiverPhone3 = null, $receiverCityName = null, $receiverTownName = null, $addressId = null, $country = null, $countryCode = null, $cityCode = null, $townCode = null, $receiverDistrictName = null, $receiverQuarterName = null, $receiverAvenueName = null, $receiverStreetName = null)
    {
        $this
            ->setImportCargoInfoId($importCargoInfoId)
            ->setReceiverName($receiverName)
            ->setReceiverAddress($receiverAddress)
            ->setReceiverPhone1($receiverPhone1)
            ->setReceiverPhone2($receiverPhone2)
            ->setReceiverPhone3($receiverPhone3)
            ->setReceiverCityName($receiverCityName)
            ->setReceiverTownName($receiverTownName)
            ->setAddressId($addressId)
            ->setCountry($country)
            ->setCountryCode($countryCode)
            ->setCityCode($cityCode)
            ->setTownCode($townCode)
            ->setReceiverDistrictName($receiverDistrictName)
            ->setReceiverQuarterName($receiverQuarterName)
            ->setReceiverAvenueName($receiverAvenueName)
            ->setReceiverStreetName($receiverStreetName);
    }
    /**
     * Get ImportCargoInfoId value
     * @return string
     */
    public function getImportCargoInfoId()
    {
        return $this->ImportCargoInfoId;
    }
    /**
     * Set ImportCargoInfoId value
     * @param string $importCargoInfoId
     * @return \StructType\AddressDto
     */
    public function setImportCargoInfoId($importCargoInfoId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($importCargoInfoId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $importCargoInfoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($importCargoInfoId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($importCargoInfoId) && !is_string($importCargoInfoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importCargoInfoId)), __LINE__);
        }
        $this->ImportCargoInfoId = $importCargoInfoId;
        return $this;
    }
    /**
     * Get ReceiverName value
     * @return string|null
     */
    public function getReceiverName()
    {
        return $this->ReceiverName;
    }
    /**
     * Set ReceiverName value
     * @param string $receiverName
     * @return \StructType\AddressDto
     */
    public function setReceiverName($receiverName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverName) && !is_string($receiverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverName)), __LINE__);
        }
        $this->ReceiverName = $receiverName;
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * @return string|null
     */
    public function getReceiverAddress()
    {
        return $this->ReceiverAddress;
    }
    /**
     * Set ReceiverAddress value
     * @param string $receiverAddress
     * @return \StructType\AddressDto
     */
    public function setReceiverAddress($receiverAddress = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress) && !is_string($receiverAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverAddress)), __LINE__);
        }
        $this->ReceiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Get ReceiverPhone1 value
     * @return string|null
     */
    public function getReceiverPhone1()
    {
        return $this->ReceiverPhone1;
    }
    /**
     * Set ReceiverPhone1 value
     * @param string $receiverPhone1
     * @return \StructType\AddressDto
     */
    public function setReceiverPhone1($receiverPhone1 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone1) && !is_string($receiverPhone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverPhone1)), __LINE__);
        }
        $this->ReceiverPhone1 = $receiverPhone1;
        return $this;
    }
    /**
     * Get ReceiverPhone2 value
     * @return string|null
     */
    public function getReceiverPhone2()
    {
        return $this->ReceiverPhone2;
    }
    /**
     * Set ReceiverPhone2 value
     * @param string $receiverPhone2
     * @return \StructType\AddressDto
     */
    public function setReceiverPhone2($receiverPhone2 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone2) && !is_string($receiverPhone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverPhone2)), __LINE__);
        }
        $this->ReceiverPhone2 = $receiverPhone2;
        return $this;
    }
    /**
     * Get ReceiverPhone3 value
     * @return string|null
     */
    public function getReceiverPhone3()
    {
        return $this->ReceiverPhone3;
    }
    /**
     * Set ReceiverPhone3 value
     * @param string $receiverPhone3
     * @return \StructType\AddressDto
     */
    public function setReceiverPhone3($receiverPhone3 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone3) && !is_string($receiverPhone3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverPhone3)), __LINE__);
        }
        $this->ReceiverPhone3 = $receiverPhone3;
        return $this;
    }
    /**
     * Get ReceiverCityName value
     * @return string|null
     */
    public function getReceiverCityName()
    {
        return $this->ReceiverCityName;
    }
    /**
     * Set ReceiverCityName value
     * @param string $receiverCityName
     * @return \StructType\AddressDto
     */
    public function setReceiverCityName($receiverCityName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverCityName) && !is_string($receiverCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverCityName)), __LINE__);
        }
        $this->ReceiverCityName = $receiverCityName;
        return $this;
    }
    /**
     * Get ReceiverTownName value
     * @return string|null
     */
    public function getReceiverTownName()
    {
        return $this->ReceiverTownName;
    }
    /**
     * Set ReceiverTownName value
     * @param string $receiverTownName
     * @return \StructType\AddressDto
     */
    public function setReceiverTownName($receiverTownName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverTownName) && !is_string($receiverTownName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverTownName)), __LINE__);
        }
        $this->ReceiverTownName = $receiverTownName;
        return $this;
    }
    /**
     * Get AddressId value
     * @return string|null
     */
    public function getAddressId()
    {
        return $this->AddressId;
    }
    /**
     * Set AddressId value
     * @param string $addressId
     * @return \StructType\AddressDto
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: string
        if (!is_null($addressId) && !is_string($addressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressId)), __LINE__);
        }
        $this->AddressId = $addressId;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\AddressDto
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\AddressDto
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \StructType\AddressDto
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get TownCode value
     * @return string|null
     */
    public function getTownCode()
    {
        return $this->TownCode;
    }
    /**
     * Set TownCode value
     * @param string $townCode
     * @return \StructType\AddressDto
     */
    public function setTownCode($townCode = null)
    {
        // validation for constraint: string
        if (!is_null($townCode) && !is_string($townCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($townCode)), __LINE__);
        }
        $this->TownCode = $townCode;
        return $this;
    }
    /**
     * Get ReceiverDistrictName value
     * @return string|null
     */
    public function getReceiverDistrictName()
    {
        return $this->ReceiverDistrictName;
    }
    /**
     * Set ReceiverDistrictName value
     * @param string $receiverDistrictName
     * @return \StructType\AddressDto
     */
    public function setReceiverDistrictName($receiverDistrictName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverDistrictName) && !is_string($receiverDistrictName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverDistrictName)), __LINE__);
        }
        $this->ReceiverDistrictName = $receiverDistrictName;
        return $this;
    }
    /**
     * Get ReceiverQuarterName value
     * @return string|null
     */
    public function getReceiverQuarterName()
    {
        return $this->ReceiverQuarterName;
    }
    /**
     * Set ReceiverQuarterName value
     * @param string $receiverQuarterName
     * @return \StructType\AddressDto
     */
    public function setReceiverQuarterName($receiverQuarterName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverQuarterName) && !is_string($receiverQuarterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverQuarterName)), __LINE__);
        }
        $this->ReceiverQuarterName = $receiverQuarterName;
        return $this;
    }
    /**
     * Get ReceiverAvenueName value
     * @return string|null
     */
    public function getReceiverAvenueName()
    {
        return $this->ReceiverAvenueName;
    }
    /**
     * Set ReceiverAvenueName value
     * @param string $receiverAvenueName
     * @return \StructType\AddressDto
     */
    public function setReceiverAvenueName($receiverAvenueName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAvenueName) && !is_string($receiverAvenueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverAvenueName)), __LINE__);
        }
        $this->ReceiverAvenueName = $receiverAvenueName;
        return $this;
    }
    /**
     * Get ReceiverStreetName value
     * @return string|null
     */
    public function getReceiverStreetName()
    {
        return $this->ReceiverStreetName;
    }
    /**
     * Set ReceiverStreetName value
     * @param string $receiverStreetName
     * @return \StructType\AddressDto
     */
    public function setReceiverStreetName($receiverStreetName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverStreetName) && !is_string($receiverStreetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverStreetName)), __LINE__);
        }
        $this->ReceiverStreetName = $receiverStreetName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressDto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
