<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCanceledShipmentInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCanceledShipmentInfo
 * @subpackage Arrays
 */
class ArrayOfCanceledShipmentInfo extends AbstractStructArrayBase
{
    /**
     * The CanceledShipmentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CanceledShipmentInfo[]
     */
    public $CanceledShipmentInfo;
    /**
     * Constructor method for ArrayOfCanceledShipmentInfo
     * @uses ArrayOfCanceledShipmentInfo::setCanceledShipmentInfo()
     * @param \StructType\CanceledShipmentInfo[] $canceledShipmentInfo
     */
    public function __construct(array $canceledShipmentInfo = array())
    {
        $this
            ->setCanceledShipmentInfo($canceledShipmentInfo);
    }
    /**
     * Get CanceledShipmentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CanceledShipmentInfo[]|null
     */
    public function getCanceledShipmentInfo()
    {
        return isset($this->CanceledShipmentInfo) ? $this->CanceledShipmentInfo : null;
    }
    /**
     * Set CanceledShipmentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CanceledShipmentInfo[] $canceledShipmentInfo
     * @return \ArrayType\ArrayOfCanceledShipmentInfo
     */
    public function setCanceledShipmentInfo(array $canceledShipmentInfo = array())
    {
        foreach ($canceledShipmentInfo as $arrayOfCanceledShipmentInfoCanceledShipmentInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCanceledShipmentInfoCanceledShipmentInfoItem instanceof \StructType\CanceledShipmentInfo) {
                throw new \InvalidArgumentException(sprintf('The CanceledShipmentInfo property can only contain items of \StructType\CanceledShipmentInfo, "%s" given', is_object($arrayOfCanceledShipmentInfoCanceledShipmentInfoItem) ? get_class($arrayOfCanceledShipmentInfoCanceledShipmentInfoItem) : gettype($arrayOfCanceledShipmentInfoCanceledShipmentInfoItem)), __LINE__);
            }
        }
        if (is_null($canceledShipmentInfo) || (is_array($canceledShipmentInfo) && empty($canceledShipmentInfo))) {
            unset($this->CanceledShipmentInfo);
        } else {
            $this->CanceledShipmentInfo = $canceledShipmentInfo;
        }
        return $this;
    }
    /**
     * Add item to CanceledShipmentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\CanceledShipmentInfo $item
     * @return \ArrayType\ArrayOfCanceledShipmentInfo
     */
    public function addToCanceledShipmentInfo(\StructType\CanceledShipmentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CanceledShipmentInfo) {
            throw new \InvalidArgumentException(sprintf('The CanceledShipmentInfo property can only contain items of \StructType\CanceledShipmentInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CanceledShipmentInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CanceledShipmentInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CanceledShipmentInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CanceledShipmentInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CanceledShipmentInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CanceledShipmentInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CanceledShipmentInfo
     */
    public function getAttributeName()
    {
        return 'CanceledShipmentInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCanceledShipmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
