<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA13 StructType
 * @subpackage Structs
 */
class WEBCARGODATA13 extends AbstractStructBase
{
    /**
     * The ISLEM_TARIHI
     * @var string
     */
    public $ISLEM_TARIHI;
    /**
     * The BIRIM
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $BIRIM;
    /**
     * The ISLEM
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $ISLEM;
    /**
     * Constructor method for WEBCARGODATA13
     * @uses WEBCARGODATA13::setISLEM_TARIHI()
     * @uses WEBCARGODATA13::setBIRIM()
     * @uses WEBCARGODATA13::setISLEM()
     * @param string $iSLEM_TARIHI
     * @param string $bIRIM
     * @param string $iSLEM
     */
    public function __construct($iSLEM_TARIHI = null, $bIRIM = null, $iSLEM = null)
    {
        $this
            ->setISLEM_TARIHI($iSLEM_TARIHI)
            ->setBIRIM($bIRIM)
            ->setISLEM($iSLEM);
    }
    /**
     * Get ISLEM_TARIHI value
     * @return string|null
     */
    public function getISLEM_TARIHI()
    {
        return $this->ISLEM_TARIHI;
    }
    /**
     * Set ISLEM_TARIHI value
     * @param string $iSLEM_TARIHI
     * @return \StructType\WEBCARGODATA13
     */
    public function setISLEM_TARIHI($iSLEM_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($iSLEM_TARIHI) && !is_string($iSLEM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSLEM_TARIHI)), __LINE__);
        }
        $this->ISLEM_TARIHI = $iSLEM_TARIHI;
        return $this;
    }
    /**
     * Get BIRIM value
     * @return string|null
     */
    public function getBIRIM()
    {
        return $this->BIRIM;
    }
    /**
     * Set BIRIM value
     * @param string $bIRIM
     * @return \StructType\WEBCARGODATA13
     */
    public function setBIRIM($bIRIM = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bIRIM) && strlen($bIRIM) > 32) || (is_array($bIRIM) && count($bIRIM) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($bIRIM) ? strlen($bIRIM) : count($bIRIM)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bIRIM) && !is_string($bIRIM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bIRIM)), __LINE__);
        }
        $this->BIRIM = $bIRIM;
        return $this;
    }
    /**
     * Get ISLEM value
     * @return string|null
     */
    public function getISLEM()
    {
        return $this->ISLEM;
    }
    /**
     * Set ISLEM value
     * @param string $iSLEM
     * @return \StructType\WEBCARGODATA13
     */
    public function setISLEM($iSLEM = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iSLEM) && strlen($iSLEM) > 128) || (is_array($iSLEM) && count($iSLEM) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($iSLEM) ? strlen($iSLEM) : count($iSLEM)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iSLEM) && !is_string($iSLEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSLEM)), __LINE__);
        }
        $this->ISLEM = $iSLEM;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WEBCARGODATA13
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
