<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeferData StructType
 * @subpackage Structs
 */
class SeferData extends AbstractStructBase
{
    /**
     * The SEFER_KODU
     * Meta informations extracted from the WSDL
     * - maxLength: 20
     * @var string
     */
    public $SEFER_KODU;
    /**
     * The CIKIS_BIRIM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $CIKIS_BIRIM;
    /**
     * The VARIS_BIRIM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $VARIS_BIRIM;
    /**
     * The ARAC_TIPI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $ARAC_TIPI;
    /**
     * The KULLANIM_TIPI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $KULLANIM_TIPI;
    /**
     * The HAT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $HAT;
    /**
     * The CIKIS_TARIHI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 19
     * @var string
     */
    public $CIKIS_TARIHI;
    /**
     * The TOPLAM_KM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 4000
     * @var string
     */
    public $TOPLAM_KM;
    /**
     * The MALIYET
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MALIYET;
    /**
     * The PLAKA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $PLAKA;
    /**
     * The ARAC_KAPASITESI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ARAC_KAPASITESI;
    /**
     * The BITIS_ZAMANI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 19
     * @var string
     */
    public $BITIS_ZAMANI;
    /**
     * Constructor method for SeferData
     * @uses SeferData::setSEFER_KODU()
     * @uses SeferData::setCIKIS_BIRIM()
     * @uses SeferData::setVARIS_BIRIM()
     * @uses SeferData::setARAC_TIPI()
     * @uses SeferData::setKULLANIM_TIPI()
     * @uses SeferData::setHAT()
     * @uses SeferData::setCIKIS_TARIHI()
     * @uses SeferData::setTOPLAM_KM()
     * @uses SeferData::setMALIYET()
     * @uses SeferData::setPLAKA()
     * @uses SeferData::setARAC_KAPASITESI()
     * @uses SeferData::setBITIS_ZAMANI()
     * @param string $sEFER_KODU
     * @param string $cIKIS_BIRIM
     * @param string $vARIS_BIRIM
     * @param string $aRAC_TIPI
     * @param string $kULLANIM_TIPI
     * @param string $hAT
     * @param string $cIKIS_TARIHI
     * @param string $tOPLAM_KM
     * @param float $mALIYET
     * @param string $pLAKA
     * @param float $aRAC_KAPASITESI
     * @param string $bITIS_ZAMANI
     */
    public function __construct($sEFER_KODU = null, $cIKIS_BIRIM = null, $vARIS_BIRIM = null, $aRAC_TIPI = null, $kULLANIM_TIPI = null, $hAT = null, $cIKIS_TARIHI = null, $tOPLAM_KM = null, $mALIYET = null, $pLAKA = null, $aRAC_KAPASITESI = null, $bITIS_ZAMANI = null)
    {
        $this
            ->setSEFER_KODU($sEFER_KODU)
            ->setCIKIS_BIRIM($cIKIS_BIRIM)
            ->setVARIS_BIRIM($vARIS_BIRIM)
            ->setARAC_TIPI($aRAC_TIPI)
            ->setKULLANIM_TIPI($kULLANIM_TIPI)
            ->setHAT($hAT)
            ->setCIKIS_TARIHI($cIKIS_TARIHI)
            ->setTOPLAM_KM($tOPLAM_KM)
            ->setMALIYET($mALIYET)
            ->setPLAKA($pLAKA)
            ->setARAC_KAPASITESI($aRAC_KAPASITESI)
            ->setBITIS_ZAMANI($bITIS_ZAMANI);
    }
    /**
     * Get SEFER_KODU value
     * @return string|null
     */
    public function getSEFER_KODU()
    {
        return $this->SEFER_KODU;
    }
    /**
     * Set SEFER_KODU value
     * @param string $sEFER_KODU
     * @return \StructType\SeferData
     */
    public function setSEFER_KODU($sEFER_KODU = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sEFER_KODU) && strlen($sEFER_KODU) > 20) || (is_array($sEFER_KODU) && count($sEFER_KODU) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($sEFER_KODU) ? strlen($sEFER_KODU) : count($sEFER_KODU)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sEFER_KODU) && !is_string($sEFER_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEFER_KODU)), __LINE__);
        }
        $this->SEFER_KODU = $sEFER_KODU;
        return $this;
    }
    /**
     * Get CIKIS_BIRIM value
     * @return string|null
     */
    public function getCIKIS_BIRIM()
    {
        return $this->CIKIS_BIRIM;
    }
    /**
     * Set CIKIS_BIRIM value
     * @param string $cIKIS_BIRIM
     * @return \StructType\SeferData
     */
    public function setCIKIS_BIRIM($cIKIS_BIRIM = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cIKIS_BIRIM) && strlen($cIKIS_BIRIM) > 30) || (is_array($cIKIS_BIRIM) && count($cIKIS_BIRIM) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($cIKIS_BIRIM) ? strlen($cIKIS_BIRIM) : count($cIKIS_BIRIM)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cIKIS_BIRIM) && !is_string($cIKIS_BIRIM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cIKIS_BIRIM)), __LINE__);
        }
        $this->CIKIS_BIRIM = $cIKIS_BIRIM;
        return $this;
    }
    /**
     * Get VARIS_BIRIM value
     * @return string|null
     */
    public function getVARIS_BIRIM()
    {
        return $this->VARIS_BIRIM;
    }
    /**
     * Set VARIS_BIRIM value
     * @param string $vARIS_BIRIM
     * @return \StructType\SeferData
     */
    public function setVARIS_BIRIM($vARIS_BIRIM = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vARIS_BIRIM) && strlen($vARIS_BIRIM) > 30) || (is_array($vARIS_BIRIM) && count($vARIS_BIRIM) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($vARIS_BIRIM) ? strlen($vARIS_BIRIM) : count($vARIS_BIRIM)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vARIS_BIRIM) && !is_string($vARIS_BIRIM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vARIS_BIRIM)), __LINE__);
        }
        $this->VARIS_BIRIM = $vARIS_BIRIM;
        return $this;
    }
    /**
     * Get ARAC_TIPI value
     * @return string|null
     */
    public function getARAC_TIPI()
    {
        return $this->ARAC_TIPI;
    }
    /**
     * Set ARAC_TIPI value
     * @param string $aRAC_TIPI
     * @return \StructType\SeferData
     */
    public function setARAC_TIPI($aRAC_TIPI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aRAC_TIPI) && strlen($aRAC_TIPI) > 20) || (is_array($aRAC_TIPI) && count($aRAC_TIPI) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($aRAC_TIPI) ? strlen($aRAC_TIPI) : count($aRAC_TIPI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aRAC_TIPI) && !is_string($aRAC_TIPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aRAC_TIPI)), __LINE__);
        }
        $this->ARAC_TIPI = $aRAC_TIPI;
        return $this;
    }
    /**
     * Get KULLANIM_TIPI value
     * @return string|null
     */
    public function getKULLANIM_TIPI()
    {
        return $this->KULLANIM_TIPI;
    }
    /**
     * Set KULLANIM_TIPI value
     * @param string $kULLANIM_TIPI
     * @return \StructType\SeferData
     */
    public function setKULLANIM_TIPI($kULLANIM_TIPI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kULLANIM_TIPI) && strlen($kULLANIM_TIPI) > 20) || (is_array($kULLANIM_TIPI) && count($kULLANIM_TIPI) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($kULLANIM_TIPI) ? strlen($kULLANIM_TIPI) : count($kULLANIM_TIPI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kULLANIM_TIPI) && !is_string($kULLANIM_TIPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kULLANIM_TIPI)), __LINE__);
        }
        $this->KULLANIM_TIPI = $kULLANIM_TIPI;
        return $this;
    }
    /**
     * Get HAT value
     * @return string|null
     */
    public function getHAT()
    {
        return $this->HAT;
    }
    /**
     * Set HAT value
     * @param string $hAT
     * @return \StructType\SeferData
     */
    public function setHAT($hAT = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hAT) && strlen($hAT) > 50) || (is_array($hAT) && count($hAT) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($hAT) ? strlen($hAT) : count($hAT)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hAT) && !is_string($hAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hAT)), __LINE__);
        }
        $this->HAT = $hAT;
        return $this;
    }
    /**
     * Get CIKIS_TARIHI value
     * @return string|null
     */
    public function getCIKIS_TARIHI()
    {
        return $this->CIKIS_TARIHI;
    }
    /**
     * Set CIKIS_TARIHI value
     * @param string $cIKIS_TARIHI
     * @return \StructType\SeferData
     */
    public function setCIKIS_TARIHI($cIKIS_TARIHI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cIKIS_TARIHI) && strlen($cIKIS_TARIHI) > 19) || (is_array($cIKIS_TARIHI) && count($cIKIS_TARIHI) > 19)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at most, "%d" length given', is_scalar($cIKIS_TARIHI) ? strlen($cIKIS_TARIHI) : count($cIKIS_TARIHI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cIKIS_TARIHI) && !is_string($cIKIS_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cIKIS_TARIHI)), __LINE__);
        }
        $this->CIKIS_TARIHI = $cIKIS_TARIHI;
        return $this;
    }
    /**
     * Get TOPLAM_KM value
     * @return string|null
     */
    public function getTOPLAM_KM()
    {
        return $this->TOPLAM_KM;
    }
    /**
     * Set TOPLAM_KM value
     * @param string $tOPLAM_KM
     * @return \StructType\SeferData
     */
    public function setTOPLAM_KM($tOPLAM_KM = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tOPLAM_KM) && strlen($tOPLAM_KM) > 4000) || (is_array($tOPLAM_KM) && count($tOPLAM_KM) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($tOPLAM_KM) ? strlen($tOPLAM_KM) : count($tOPLAM_KM)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tOPLAM_KM) && !is_string($tOPLAM_KM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tOPLAM_KM)), __LINE__);
        }
        $this->TOPLAM_KM = $tOPLAM_KM;
        return $this;
    }
    /**
     * Get MALIYET value
     * @return float|null
     */
    public function getMALIYET()
    {
        return $this->MALIYET;
    }
    /**
     * Set MALIYET value
     * @param float $mALIYET
     * @return \StructType\SeferData
     */
    public function setMALIYET($mALIYET = null)
    {
        $this->MALIYET = $mALIYET;
        return $this;
    }
    /**
     * Get PLAKA value
     * @return string|null
     */
    public function getPLAKA()
    {
        return $this->PLAKA;
    }
    /**
     * Set PLAKA value
     * @param string $pLAKA
     * @return \StructType\SeferData
     */
    public function setPLAKA($pLAKA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pLAKA) && strlen($pLAKA) > 10) || (is_array($pLAKA) && count($pLAKA) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($pLAKA) ? strlen($pLAKA) : count($pLAKA)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pLAKA) && !is_string($pLAKA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pLAKA)), __LINE__);
        }
        $this->PLAKA = $pLAKA;
        return $this;
    }
    /**
     * Get ARAC_KAPASITESI value
     * @return float|null
     */
    public function getARAC_KAPASITESI()
    {
        return $this->ARAC_KAPASITESI;
    }
    /**
     * Set ARAC_KAPASITESI value
     * @param float $aRAC_KAPASITESI
     * @return \StructType\SeferData
     */
    public function setARAC_KAPASITESI($aRAC_KAPASITESI = null)
    {
        $this->ARAC_KAPASITESI = $aRAC_KAPASITESI;
        return $this;
    }
    /**
     * Get BITIS_ZAMANI value
     * @return string|null
     */
    public function getBITIS_ZAMANI()
    {
        return $this->BITIS_ZAMANI;
    }
    /**
     * Set BITIS_ZAMANI value
     * @param string $bITIS_ZAMANI
     * @return \StructType\SeferData
     */
    public function setBITIS_ZAMANI($bITIS_ZAMANI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bITIS_ZAMANI) && strlen($bITIS_ZAMANI) > 19) || (is_array($bITIS_ZAMANI) && count($bITIS_ZAMANI) > 19)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 19 element(s) or a scalar of 19 character(s) at most, "%d" length given', is_scalar($bITIS_ZAMANI) ? strlen($bITIS_ZAMANI) : count($bITIS_ZAMANI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bITIS_ZAMANI) && !is_string($bITIS_ZAMANI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bITIS_ZAMANI)), __LINE__);
        }
        $this->BITIS_ZAMANI = $bITIS_ZAMANI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeferData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
