<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderResultInfo StructType
 * @subpackage Structs
 */
class OrderResultInfo extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * The InvoiceKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceKey;
    /**
     * The OrgReceiverCustId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrgReceiverCustId;
    /**
     * Constructor method for OrderResultInfo
     * @uses OrderResultInfo::setResultCode()
     * @uses OrderResultInfo::setResultMessage()
     * @uses OrderResultInfo::setInvoiceKey()
     * @uses OrderResultInfo::setOrgReceiverCustId()
     * @param string $resultCode
     * @param string $resultMessage
     * @param string $invoiceKey
     * @param string $orgReceiverCustId
     */
    public function __construct($resultCode = null, $resultMessage = null, $invoiceKey = null, $orgReceiverCustId = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage)
            ->setInvoiceKey($invoiceKey)
            ->setOrgReceiverCustId($orgReceiverCustId);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\OrderResultInfo
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \StructType\OrderResultInfo
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get InvoiceKey value
     * @return string|null
     */
    public function getInvoiceKey()
    {
        return $this->InvoiceKey;
    }
    /**
     * Set InvoiceKey value
     * @param string $invoiceKey
     * @return \StructType\OrderResultInfo
     */
    public function setInvoiceKey($invoiceKey = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceKey) && !is_string($invoiceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceKey)), __LINE__);
        }
        $this->InvoiceKey = $invoiceKey;
        return $this;
    }
    /**
     * Get OrgReceiverCustId value
     * @return string|null
     */
    public function getOrgReceiverCustId()
    {
        return $this->OrgReceiverCustId;
    }
    /**
     * Set OrgReceiverCustId value
     * @param string $orgReceiverCustId
     * @return \StructType\OrderResultInfo
     */
    public function setOrgReceiverCustId($orgReceiverCustId = null)
    {
        // validation for constraint: string
        if (!is_null($orgReceiverCustId) && !is_string($orgReceiverCustId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orgReceiverCustId)), __LINE__);
        }
        $this->OrgReceiverCustId = $orgReceiverCustId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderResultInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
