<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GunlukDesi StructType
 * @subpackage Structs
 */
class GunlukDesi extends AbstractStructBase
{
    /**
     * The CIKIS_TM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $CIKIS_TM;
    /**
     * The VARIS_TM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 30
     * @var string
     */
    public $VARIS_TM;
    /**
     * The TARIH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TARIH;
    /**
     * The DESI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * Constructor method for GunlukDesi
     * @uses GunlukDesi::setCIKIS_TM()
     * @uses GunlukDesi::setVARIS_TM()
     * @uses GunlukDesi::setTARIH()
     * @uses GunlukDesi::setDESI()
     * @param string $cIKIS_TM
     * @param string $vARIS_TM
     * @param string $tARIH
     * @param float $dESI
     */
    public function __construct($cIKIS_TM = null, $vARIS_TM = null, $tARIH = null, $dESI = null)
    {
        $this
            ->setCIKIS_TM($cIKIS_TM)
            ->setVARIS_TM($vARIS_TM)
            ->setTARIH($tARIH)
            ->setDESI($dESI);
    }
    /**
     * Get CIKIS_TM value
     * @return string|null
     */
    public function getCIKIS_TM()
    {
        return $this->CIKIS_TM;
    }
    /**
     * Set CIKIS_TM value
     * @param string $cIKIS_TM
     * @return \StructType\GunlukDesi
     */
    public function setCIKIS_TM($cIKIS_TM = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cIKIS_TM) && strlen($cIKIS_TM) > 30) || (is_array($cIKIS_TM) && count($cIKIS_TM) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($cIKIS_TM) ? strlen($cIKIS_TM) : count($cIKIS_TM)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cIKIS_TM) && !is_string($cIKIS_TM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cIKIS_TM)), __LINE__);
        }
        $this->CIKIS_TM = $cIKIS_TM;
        return $this;
    }
    /**
     * Get VARIS_TM value
     * @return string|null
     */
    public function getVARIS_TM()
    {
        return $this->VARIS_TM;
    }
    /**
     * Set VARIS_TM value
     * @param string $vARIS_TM
     * @return \StructType\GunlukDesi
     */
    public function setVARIS_TM($vARIS_TM = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vARIS_TM) && strlen($vARIS_TM) > 30) || (is_array($vARIS_TM) && count($vARIS_TM) > 30)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 30 element(s) or a scalar of 30 character(s) at most, "%d" length given', is_scalar($vARIS_TM) ? strlen($vARIS_TM) : count($vARIS_TM)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vARIS_TM) && !is_string($vARIS_TM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vARIS_TM)), __LINE__);
        }
        $this->VARIS_TM = $vARIS_TM;
        return $this;
    }
    /**
     * Get TARIH value
     * @return string|null
     */
    public function getTARIH()
    {
        return $this->TARIH;
    }
    /**
     * Set TARIH value
     * @param string $tARIH
     * @return \StructType\GunlukDesi
     */
    public function setTARIH($tARIH = null)
    {
        // validation for constraint: string
        if (!is_null($tARIH) && !is_string($tARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tARIH)), __LINE__);
        }
        $this->TARIH = $tARIH;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \StructType\GunlukDesi
     */
    public function setDESI($dESI = null)
    {
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GunlukDesi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
