<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCargoTransaction StructType
 * @subpackage Structs
 */
class GetCargoTransaction extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The integrationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $integrationCode;
    /**
     * Constructor method for GetCargoTransaction
     * @uses GetCargoTransaction::setUsername()
     * @uses GetCargoTransaction::setPassword()
     * @uses GetCargoTransaction::setCode()
     * @uses GetCargoTransaction::setIntegrationCode()
     * @param string $username
     * @param string $password
     * @param string $code
     * @param string $integrationCode
     */
    public function __construct($username = null, $password = null, $code = null, $integrationCode = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setCode($code)
            ->setIntegrationCode($integrationCode);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\GetCargoTransaction
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetCargoTransaction
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\GetCargoTransaction
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get integrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->integrationCode;
    }
    /**
     * Set integrationCode value
     * @param string $integrationCode
     * @return \StructType\GetCargoTransaction
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integrationCode)), __LINE__);
        }
        $this->integrationCode = $integrationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCargoTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
