<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispatchResultInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DispatchResultInfo
 * @subpackage Structs
 */
class DispatchResultInfo extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * The CargoKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CargoKey;
    /**
     * Constructor method for DispatchResultInfo
     * @uses DispatchResultInfo::setResultCode()
     * @uses DispatchResultInfo::setResultMessage()
     * @uses DispatchResultInfo::setCargoKey()
     * @param string $resultCode
     * @param string $resultMessage
     * @param string $cargoKey
     */
    public function __construct($resultCode = null, $resultMessage = null, $cargoKey = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage)
            ->setCargoKey($cargoKey);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \StructType\DispatchResultInfo
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \StructType\DispatchResultInfo
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get CargoKey value
     * @return string|null
     */
    public function getCargoKey()
    {
        return $this->CargoKey;
    }
    /**
     * Set CargoKey value
     * @param string $cargoKey
     * @return \StructType\DispatchResultInfo
     */
    public function setCargoKey($cargoKey = null)
    {
        // validation for constraint: string
        if (!is_null($cargoKey) && !is_string($cargoKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cargoKey)), __LINE__);
        }
        $this->CargoKey = $cargoKey;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DispatchResultInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
