<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CanceledShipmentInfo StructType
 * @subpackage Structs
 */
class CanceledShipmentInfo extends AbstractStructBase
{
    /**
     * The SuccessFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuccessFlag;
    /**
     * The OperationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationCode;
    /**
     * The LastOperationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastOperationDate;
    /**
     * The LastOperationTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastOperationTime;
    /**
     * The CargoKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CargoKey;
    /**
     * The InvoiceKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceKey;
    /**
     * The OperationMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationMessage;
    /**
     * The CanceledDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CanceledDescription;
    /**
     * Constructor method for CanceledShipmentInfo
     * @uses CanceledShipmentInfo::setSuccessFlag()
     * @uses CanceledShipmentInfo::setOperationCode()
     * @uses CanceledShipmentInfo::setLastOperationDate()
     * @uses CanceledShipmentInfo::setLastOperationTime()
     * @uses CanceledShipmentInfo::setCargoKey()
     * @uses CanceledShipmentInfo::setInvoiceKey()
     * @uses CanceledShipmentInfo::setOperationMessage()
     * @uses CanceledShipmentInfo::setCanceledDescription()
     * @param string $successFlag
     * @param string $operationCode
     * @param string $lastOperationDate
     * @param string $lastOperationTime
     * @param string $cargoKey
     * @param string $invoiceKey
     * @param string $operationMessage
     * @param string $canceledDescription
     */
    public function __construct($successFlag = null, $operationCode = null, $lastOperationDate = null, $lastOperationTime = null, $cargoKey = null, $invoiceKey = null, $operationMessage = null, $canceledDescription = null)
    {
        $this
            ->setSuccessFlag($successFlag)
            ->setOperationCode($operationCode)
            ->setLastOperationDate($lastOperationDate)
            ->setLastOperationTime($lastOperationTime)
            ->setCargoKey($cargoKey)
            ->setInvoiceKey($invoiceKey)
            ->setOperationMessage($operationMessage)
            ->setCanceledDescription($canceledDescription);
    }
    /**
     * Get SuccessFlag value
     * @return string|null
     */
    public function getSuccessFlag()
    {
        return $this->SuccessFlag;
    }
    /**
     * Set SuccessFlag value
     * @param string $successFlag
     * @return \StructType\CanceledShipmentInfo
     */
    public function setSuccessFlag($successFlag = null)
    {
        // validation for constraint: string
        if (!is_null($successFlag) && !is_string($successFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($successFlag)), __LINE__);
        }
        $this->SuccessFlag = $successFlag;
        return $this;
    }
    /**
     * Get OperationCode value
     * @return string|null
     */
    public function getOperationCode()
    {
        return $this->OperationCode;
    }
    /**
     * Set OperationCode value
     * @param string $operationCode
     * @return \StructType\CanceledShipmentInfo
     */
    public function setOperationCode($operationCode = null)
    {
        // validation for constraint: string
        if (!is_null($operationCode) && !is_string($operationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationCode)), __LINE__);
        }
        $this->OperationCode = $operationCode;
        return $this;
    }
    /**
     * Get LastOperationDate value
     * @return string|null
     */
    public function getLastOperationDate()
    {
        return $this->LastOperationDate;
    }
    /**
     * Set LastOperationDate value
     * @param string $lastOperationDate
     * @return \StructType\CanceledShipmentInfo
     */
    public function setLastOperationDate($lastOperationDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastOperationDate) && !is_string($lastOperationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastOperationDate)), __LINE__);
        }
        $this->LastOperationDate = $lastOperationDate;
        return $this;
    }
    /**
     * Get LastOperationTime value
     * @return string|null
     */
    public function getLastOperationTime()
    {
        return $this->LastOperationTime;
    }
    /**
     * Set LastOperationTime value
     * @param string $lastOperationTime
     * @return \StructType\CanceledShipmentInfo
     */
    public function setLastOperationTime($lastOperationTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastOperationTime) && !is_string($lastOperationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastOperationTime)), __LINE__);
        }
        $this->LastOperationTime = $lastOperationTime;
        return $this;
    }
    /**
     * Get CargoKey value
     * @return string|null
     */
    public function getCargoKey()
    {
        return $this->CargoKey;
    }
    /**
     * Set CargoKey value
     * @param string $cargoKey
     * @return \StructType\CanceledShipmentInfo
     */
    public function setCargoKey($cargoKey = null)
    {
        // validation for constraint: string
        if (!is_null($cargoKey) && !is_string($cargoKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cargoKey)), __LINE__);
        }
        $this->CargoKey = $cargoKey;
        return $this;
    }
    /**
     * Get InvoiceKey value
     * @return string|null
     */
    public function getInvoiceKey()
    {
        return $this->InvoiceKey;
    }
    /**
     * Set InvoiceKey value
     * @param string $invoiceKey
     * @return \StructType\CanceledShipmentInfo
     */
    public function setInvoiceKey($invoiceKey = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceKey) && !is_string($invoiceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceKey)), __LINE__);
        }
        $this->InvoiceKey = $invoiceKey;
        return $this;
    }
    /**
     * Get OperationMessage value
     * @return string|null
     */
    public function getOperationMessage()
    {
        return $this->OperationMessage;
    }
    /**
     * Set OperationMessage value
     * @param string $operationMessage
     * @return \StructType\CanceledShipmentInfo
     */
    public function setOperationMessage($operationMessage = null)
    {
        // validation for constraint: string
        if (!is_null($operationMessage) && !is_string($operationMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationMessage)), __LINE__);
        }
        $this->OperationMessage = $operationMessage;
        return $this;
    }
    /**
     * Get CanceledDescription value
     * @return string|null
     */
    public function getCanceledDescription()
    {
        return $this->CanceledDescription;
    }
    /**
     * Set CanceledDescription value
     * @param string $canceledDescription
     * @return \StructType\CanceledShipmentInfo
     */
    public function setCanceledDescription($canceledDescription = null)
    {
        // validation for constraint: string
        if (!is_null($canceledDescription) && !is_string($canceledDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($canceledDescription)), __LINE__);
        }
        $this->CanceledDescription = $canceledDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CanceledShipmentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
