<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarcodeModel StructType
 * @subpackage Structs
 */
class BarcodeModel extends AbstractStructBase
{
    /**
     * The Volume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Volume;
    /**
     * The TotalVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalVolume;
    /**
     * The BarcodeDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BarcodeDate;
    /**
     * The DeliveryUnitID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryUnitID;
    /**
     * The SourceUnitID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceUnitID;
    /**
     * The PieceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PieceNumber;
    /**
     * The PieceCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PieceCount;
    /**
     * The CashPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CashPrice;
    /**
     * The SenderAccountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAccountName;
    /**
     * The SenderAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAddress;
    /**
     * The SenderAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAddress2;
    /**
     * The ReceiverAccountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAccountName;
    /**
     * The ReceiverAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAddress;
    /**
     * The ReceiverAddress2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAddress2;
    /**
     * The ReceiverPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhone;
    /**
     * The ReceiverPhone2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhone2;
    /**
     * The ReceiverTown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverTown;
    /**
     * The ReceiverCity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverCity;
    /**
     * The DeliveryUnitName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryUnitName;
    /**
     * The SourceUnitName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceUnitName;
    /**
     * The TrackingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The IntegrationCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegrationCode;
    /**
     * The Msi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Msi;
    /**
     * The MainServiceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainServiceName;
    /**
     * The RouteName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RouteName;
    /**
     * The WaybillSerial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WaybillSerial;
    /**
     * The WaybillNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WaybillNumber;
    /**
     * The LovShipmentTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovShipmentTypeName;
    /**
     * The LovPacketTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovPacketTypeName;
    /**
     * The LovPayorTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovPayorTypeName;
    /**
     * The SenderPhone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderPhone;
    /**
     * The ExServiceCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $ExServiceCodes;
    /**
     * The WaybillDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WaybillDate;
    /**
     * The LovDeliveryTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovDeliveryTypeName;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * Constructor method for BarcodeModel
     * @uses BarcodeModel::setVolume()
     * @uses BarcodeModel::setTotalVolume()
     * @uses BarcodeModel::setBarcodeDate()
     * @uses BarcodeModel::setDeliveryUnitID()
     * @uses BarcodeModel::setSourceUnitID()
     * @uses BarcodeModel::setPieceNumber()
     * @uses BarcodeModel::setPieceCount()
     * @uses BarcodeModel::setCashPrice()
     * @uses BarcodeModel::setSenderAccountName()
     * @uses BarcodeModel::setSenderAddress()
     * @uses BarcodeModel::setSenderAddress2()
     * @uses BarcodeModel::setReceiverAccountName()
     * @uses BarcodeModel::setReceiverAddress()
     * @uses BarcodeModel::setReceiverAddress2()
     * @uses BarcodeModel::setReceiverPhone()
     * @uses BarcodeModel::setReceiverPhone2()
     * @uses BarcodeModel::setReceiverTown()
     * @uses BarcodeModel::setReceiverCity()
     * @uses BarcodeModel::setDeliveryUnitName()
     * @uses BarcodeModel::setSourceUnitName()
     * @uses BarcodeModel::setTrackingNumber()
     * @uses BarcodeModel::setIntegrationCode()
     * @uses BarcodeModel::setMsi()
     * @uses BarcodeModel::setMainServiceName()
     * @uses BarcodeModel::setRouteName()
     * @uses BarcodeModel::setWaybillSerial()
     * @uses BarcodeModel::setWaybillNumber()
     * @uses BarcodeModel::setLovShipmentTypeName()
     * @uses BarcodeModel::setLovPacketTypeName()
     * @uses BarcodeModel::setLovPayorTypeName()
     * @uses BarcodeModel::setSenderPhone()
     * @uses BarcodeModel::setExServiceCodes()
     * @uses BarcodeModel::setWaybillDate()
     * @uses BarcodeModel::setLovDeliveryTypeName()
     * @uses BarcodeModel::setBarcode()
     * @uses BarcodeModel::setPaymentType()
     * @param float $volume
     * @param float $totalVolume
     * @param string $barcodeDate
     * @param int $deliveryUnitID
     * @param int $sourceUnitID
     * @param int $pieceNumber
     * @param int $pieceCount
     * @param float $cashPrice
     * @param string $senderAccountName
     * @param string $senderAddress
     * @param string $senderAddress2
     * @param string $receiverAccountName
     * @param string $receiverAddress
     * @param string $receiverAddress2
     * @param string $receiverPhone
     * @param string $receiverPhone2
     * @param string $receiverTown
     * @param string $receiverCity
     * @param string $deliveryUnitName
     * @param string $sourceUnitName
     * @param string $trackingNumber
     * @param string $integrationCode
     * @param string $msi
     * @param string $mainServiceName
     * @param string $routeName
     * @param string $waybillSerial
     * @param string $waybillNumber
     * @param string $lovShipmentTypeName
     * @param string $lovPacketTypeName
     * @param string $lovPayorTypeName
     * @param string $senderPhone
     * @param \ArrayType\ArrayOfString $exServiceCodes
     * @param string $waybillDate
     * @param string $lovDeliveryTypeName
     * @param string $barcode
     * @param string $paymentType
     */
    public function __construct($volume = null, $totalVolume = null, $barcodeDate = null, $deliveryUnitID = null, $sourceUnitID = null, $pieceNumber = null, $pieceCount = null, $cashPrice = null, $senderAccountName = null, $senderAddress = null, $senderAddress2 = null, $receiverAccountName = null, $receiverAddress = null, $receiverAddress2 = null, $receiverPhone = null, $receiverPhone2 = null, $receiverTown = null, $receiverCity = null, $deliveryUnitName = null, $sourceUnitName = null, $trackingNumber = null, $integrationCode = null, $msi = null, $mainServiceName = null, $routeName = null, $waybillSerial = null, $waybillNumber = null, $lovShipmentTypeName = null, $lovPacketTypeName = null, $lovPayorTypeName = null, $senderPhone = null, \ArrayType\ArrayOfString $exServiceCodes = null, $waybillDate = null, $lovDeliveryTypeName = null, $barcode = null, $paymentType = null)
    {
        $this
            ->setVolume($volume)
            ->setTotalVolume($totalVolume)
            ->setBarcodeDate($barcodeDate)
            ->setDeliveryUnitID($deliveryUnitID)
            ->setSourceUnitID($sourceUnitID)
            ->setPieceNumber($pieceNumber)
            ->setPieceCount($pieceCount)
            ->setCashPrice($cashPrice)
            ->setSenderAccountName($senderAccountName)
            ->setSenderAddress($senderAddress)
            ->setSenderAddress2($senderAddress2)
            ->setReceiverAccountName($receiverAccountName)
            ->setReceiverAddress($receiverAddress)
            ->setReceiverAddress2($receiverAddress2)
            ->setReceiverPhone($receiverPhone)
            ->setReceiverPhone2($receiverPhone2)
            ->setReceiverTown($receiverTown)
            ->setReceiverCity($receiverCity)
            ->setDeliveryUnitName($deliveryUnitName)
            ->setSourceUnitName($sourceUnitName)
            ->setTrackingNumber($trackingNumber)
            ->setIntegrationCode($integrationCode)
            ->setMsi($msi)
            ->setMainServiceName($mainServiceName)
            ->setRouteName($routeName)
            ->setWaybillSerial($waybillSerial)
            ->setWaybillNumber($waybillNumber)
            ->setLovShipmentTypeName($lovShipmentTypeName)
            ->setLovPacketTypeName($lovPacketTypeName)
            ->setLovPayorTypeName($lovPayorTypeName)
            ->setSenderPhone($senderPhone)
            ->setExServiceCodes($exServiceCodes)
            ->setWaybillDate($waybillDate)
            ->setLovDeliveryTypeName($lovDeliveryTypeName)
            ->setBarcode($barcode)
            ->setPaymentType($paymentType);
    }
    /**
     * Get Volume value
     * @return float
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \StructType\BarcodeModel
     */
    public function setVolume($volume = null)
    {
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get TotalVolume value
     * @return float
     */
    public function getTotalVolume()
    {
        return $this->TotalVolume;
    }
    /**
     * Set TotalVolume value
     * @param float $totalVolume
     * @return \StructType\BarcodeModel
     */
    public function setTotalVolume($totalVolume = null)
    {
        $this->TotalVolume = $totalVolume;
        return $this;
    }
    /**
     * Get BarcodeDate value
     * @return string
     */
    public function getBarcodeDate()
    {
        return $this->BarcodeDate;
    }
    /**
     * Set BarcodeDate value
     * @param string $barcodeDate
     * @return \StructType\BarcodeModel
     */
    public function setBarcodeDate($barcodeDate = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeDate) && !is_string($barcodeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcodeDate)), __LINE__);
        }
        $this->BarcodeDate = $barcodeDate;
        return $this;
    }
    /**
     * Get DeliveryUnitID value
     * @return int
     */
    public function getDeliveryUnitID()
    {
        return $this->DeliveryUnitID;
    }
    /**
     * Set DeliveryUnitID value
     * @param int $deliveryUnitID
     * @return \StructType\BarcodeModel
     */
    public function setDeliveryUnitID($deliveryUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryUnitID) && !is_numeric($deliveryUnitID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deliveryUnitID)), __LINE__);
        }
        $this->DeliveryUnitID = $deliveryUnitID;
        return $this;
    }
    /**
     * Get SourceUnitID value
     * @return int
     */
    public function getSourceUnitID()
    {
        return $this->SourceUnitID;
    }
    /**
     * Set SourceUnitID value
     * @param int $sourceUnitID
     * @return \StructType\BarcodeModel
     */
    public function setSourceUnitID($sourceUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceUnitID) && !is_numeric($sourceUnitID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceUnitID)), __LINE__);
        }
        $this->SourceUnitID = $sourceUnitID;
        return $this;
    }
    /**
     * Get PieceNumber value
     * @return int
     */
    public function getPieceNumber()
    {
        return $this->PieceNumber;
    }
    /**
     * Set PieceNumber value
     * @param int $pieceNumber
     * @return \StructType\BarcodeModel
     */
    public function setPieceNumber($pieceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pieceNumber) && !is_numeric($pieceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pieceNumber)), __LINE__);
        }
        $this->PieceNumber = $pieceNumber;
        return $this;
    }
    /**
     * Get PieceCount value
     * @return int
     */
    public function getPieceCount()
    {
        return $this->PieceCount;
    }
    /**
     * Set PieceCount value
     * @param int $pieceCount
     * @return \StructType\BarcodeModel
     */
    public function setPieceCount($pieceCount = null)
    {
        // validation for constraint: int
        if (!is_null($pieceCount) && !is_numeric($pieceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pieceCount)), __LINE__);
        }
        $this->PieceCount = $pieceCount;
        return $this;
    }
    /**
     * Get CashPrice value
     * @return float
     */
    public function getCashPrice()
    {
        return $this->CashPrice;
    }
    /**
     * Set CashPrice value
     * @param float $cashPrice
     * @return \StructType\BarcodeModel
     */
    public function setCashPrice($cashPrice = null)
    {
        $this->CashPrice = $cashPrice;
        return $this;
    }
    /**
     * Get SenderAccountName value
     * @return string|null
     */
    public function getSenderAccountName()
    {
        return $this->SenderAccountName;
    }
    /**
     * Set SenderAccountName value
     * @param string $senderAccountName
     * @return \StructType\BarcodeModel
     */
    public function setSenderAccountName($senderAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($senderAccountName) && !is_string($senderAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderAccountName)), __LINE__);
        }
        $this->SenderAccountName = $senderAccountName;
        return $this;
    }
    /**
     * Get SenderAddress value
     * @return string|null
     */
    public function getSenderAddress()
    {
        return $this->SenderAddress;
    }
    /**
     * Set SenderAddress value
     * @param string $senderAddress
     * @return \StructType\BarcodeModel
     */
    public function setSenderAddress($senderAddress = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress) && !is_string($senderAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderAddress)), __LINE__);
        }
        $this->SenderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get SenderAddress2 value
     * @return string|null
     */
    public function getSenderAddress2()
    {
        return $this->SenderAddress2;
    }
    /**
     * Set SenderAddress2 value
     * @param string $senderAddress2
     * @return \StructType\BarcodeModel
     */
    public function setSenderAddress2($senderAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress2) && !is_string($senderAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderAddress2)), __LINE__);
        }
        $this->SenderAddress2 = $senderAddress2;
        return $this;
    }
    /**
     * Get ReceiverAccountName value
     * @return string|null
     */
    public function getReceiverAccountName()
    {
        return $this->ReceiverAccountName;
    }
    /**
     * Set ReceiverAccountName value
     * @param string $receiverAccountName
     * @return \StructType\BarcodeModel
     */
    public function setReceiverAccountName($receiverAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAccountName) && !is_string($receiverAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverAccountName)), __LINE__);
        }
        $this->ReceiverAccountName = $receiverAccountName;
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * @return string|null
     */
    public function getReceiverAddress()
    {
        return $this->ReceiverAddress;
    }
    /**
     * Set ReceiverAddress value
     * @param string $receiverAddress
     * @return \StructType\BarcodeModel
     */
    public function setReceiverAddress($receiverAddress = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress) && !is_string($receiverAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverAddress)), __LINE__);
        }
        $this->ReceiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Get ReceiverAddress2 value
     * @return string|null
     */
    public function getReceiverAddress2()
    {
        return $this->ReceiverAddress2;
    }
    /**
     * Set ReceiverAddress2 value
     * @param string $receiverAddress2
     * @return \StructType\BarcodeModel
     */
    public function setReceiverAddress2($receiverAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress2) && !is_string($receiverAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverAddress2)), __LINE__);
        }
        $this->ReceiverAddress2 = $receiverAddress2;
        return $this;
    }
    /**
     * Get ReceiverPhone value
     * @return string|null
     */
    public function getReceiverPhone()
    {
        return $this->ReceiverPhone;
    }
    /**
     * Set ReceiverPhone value
     * @param string $receiverPhone
     * @return \StructType\BarcodeModel
     */
    public function setReceiverPhone($receiverPhone = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone) && !is_string($receiverPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverPhone)), __LINE__);
        }
        $this->ReceiverPhone = $receiverPhone;
        return $this;
    }
    /**
     * Get ReceiverPhone2 value
     * @return string|null
     */
    public function getReceiverPhone2()
    {
        return $this->ReceiverPhone2;
    }
    /**
     * Set ReceiverPhone2 value
     * @param string $receiverPhone2
     * @return \StructType\BarcodeModel
     */
    public function setReceiverPhone2($receiverPhone2 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone2) && !is_string($receiverPhone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverPhone2)), __LINE__);
        }
        $this->ReceiverPhone2 = $receiverPhone2;
        return $this;
    }
    /**
     * Get ReceiverTown value
     * @return string|null
     */
    public function getReceiverTown()
    {
        return $this->ReceiverTown;
    }
    /**
     * Set ReceiverTown value
     * @param string $receiverTown
     * @return \StructType\BarcodeModel
     */
    public function setReceiverTown($receiverTown = null)
    {
        // validation for constraint: string
        if (!is_null($receiverTown) && !is_string($receiverTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverTown)), __LINE__);
        }
        $this->ReceiverTown = $receiverTown;
        return $this;
    }
    /**
     * Get ReceiverCity value
     * @return string|null
     */
    public function getReceiverCity()
    {
        return $this->ReceiverCity;
    }
    /**
     * Set ReceiverCity value
     * @param string $receiverCity
     * @return \StructType\BarcodeModel
     */
    public function setReceiverCity($receiverCity = null)
    {
        // validation for constraint: string
        if (!is_null($receiverCity) && !is_string($receiverCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverCity)), __LINE__);
        }
        $this->ReceiverCity = $receiverCity;
        return $this;
    }
    /**
     * Get DeliveryUnitName value
     * @return string|null
     */
    public function getDeliveryUnitName()
    {
        return $this->DeliveryUnitName;
    }
    /**
     * Set DeliveryUnitName value
     * @param string $deliveryUnitName
     * @return \StructType\BarcodeModel
     */
    public function setDeliveryUnitName($deliveryUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryUnitName) && !is_string($deliveryUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryUnitName)), __LINE__);
        }
        $this->DeliveryUnitName = $deliveryUnitName;
        return $this;
    }
    /**
     * Get SourceUnitName value
     * @return string|null
     */
    public function getSourceUnitName()
    {
        return $this->SourceUnitName;
    }
    /**
     * Set SourceUnitName value
     * @param string $sourceUnitName
     * @return \StructType\BarcodeModel
     */
    public function setSourceUnitName($sourceUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($sourceUnitName) && !is_string($sourceUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceUnitName)), __LINE__);
        }
        $this->SourceUnitName = $sourceUnitName;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \StructType\BarcodeModel
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get IntegrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->IntegrationCode;
    }
    /**
     * Set IntegrationCode value
     * @param string $integrationCode
     * @return \StructType\BarcodeModel
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($integrationCode)), __LINE__);
        }
        $this->IntegrationCode = $integrationCode;
        return $this;
    }
    /**
     * Get Msi value
     * @return string|null
     */
    public function getMsi()
    {
        return $this->Msi;
    }
    /**
     * Set Msi value
     * @param string $msi
     * @return \StructType\BarcodeModel
     */
    public function setMsi($msi = null)
    {
        // validation for constraint: string
        if (!is_null($msi) && !is_string($msi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msi)), __LINE__);
        }
        $this->Msi = $msi;
        return $this;
    }
    /**
     * Get MainServiceName value
     * @return string|null
     */
    public function getMainServiceName()
    {
        return $this->MainServiceName;
    }
    /**
     * Set MainServiceName value
     * @param string $mainServiceName
     * @return \StructType\BarcodeModel
     */
    public function setMainServiceName($mainServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($mainServiceName) && !is_string($mainServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mainServiceName)), __LINE__);
        }
        $this->MainServiceName = $mainServiceName;
        return $this;
    }
    /**
     * Get RouteName value
     * @return string|null
     */
    public function getRouteName()
    {
        return $this->RouteName;
    }
    /**
     * Set RouteName value
     * @param string $routeName
     * @return \StructType\BarcodeModel
     */
    public function setRouteName($routeName = null)
    {
        // validation for constraint: string
        if (!is_null($routeName) && !is_string($routeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeName)), __LINE__);
        }
        $this->RouteName = $routeName;
        return $this;
    }
    /**
     * Get WaybillSerial value
     * @return string|null
     */
    public function getWaybillSerial()
    {
        return $this->WaybillSerial;
    }
    /**
     * Set WaybillSerial value
     * @param string $waybillSerial
     * @return \StructType\BarcodeModel
     */
    public function setWaybillSerial($waybillSerial = null)
    {
        // validation for constraint: string
        if (!is_null($waybillSerial) && !is_string($waybillSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waybillSerial)), __LINE__);
        }
        $this->WaybillSerial = $waybillSerial;
        return $this;
    }
    /**
     * Get WaybillNumber value
     * @return string|null
     */
    public function getWaybillNumber()
    {
        return $this->WaybillNumber;
    }
    /**
     * Set WaybillNumber value
     * @param string $waybillNumber
     * @return \StructType\BarcodeModel
     */
    public function setWaybillNumber($waybillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($waybillNumber) && !is_string($waybillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waybillNumber)), __LINE__);
        }
        $this->WaybillNumber = $waybillNumber;
        return $this;
    }
    /**
     * Get LovShipmentTypeName value
     * @return string|null
     */
    public function getLovShipmentTypeName()
    {
        return $this->LovShipmentTypeName;
    }
    /**
     * Set LovShipmentTypeName value
     * @param string $lovShipmentTypeName
     * @return \StructType\BarcodeModel
     */
    public function setLovShipmentTypeName($lovShipmentTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovShipmentTypeName) && !is_string($lovShipmentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lovShipmentTypeName)), __LINE__);
        }
        $this->LovShipmentTypeName = $lovShipmentTypeName;
        return $this;
    }
    /**
     * Get LovPacketTypeName value
     * @return string|null
     */
    public function getLovPacketTypeName()
    {
        return $this->LovPacketTypeName;
    }
    /**
     * Set LovPacketTypeName value
     * @param string $lovPacketTypeName
     * @return \StructType\BarcodeModel
     */
    public function setLovPacketTypeName($lovPacketTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovPacketTypeName) && !is_string($lovPacketTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lovPacketTypeName)), __LINE__);
        }
        $this->LovPacketTypeName = $lovPacketTypeName;
        return $this;
    }
    /**
     * Get LovPayorTypeName value
     * @return string|null
     */
    public function getLovPayorTypeName()
    {
        return $this->LovPayorTypeName;
    }
    /**
     * Set LovPayorTypeName value
     * @param string $lovPayorTypeName
     * @return \StructType\BarcodeModel
     */
    public function setLovPayorTypeName($lovPayorTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovPayorTypeName) && !is_string($lovPayorTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lovPayorTypeName)), __LINE__);
        }
        $this->LovPayorTypeName = $lovPayorTypeName;
        return $this;
    }
    /**
     * Get SenderPhone value
     * @return string|null
     */
    public function getSenderPhone()
    {
        return $this->SenderPhone;
    }
    /**
     * Set SenderPhone value
     * @param string $senderPhone
     * @return \StructType\BarcodeModel
     */
    public function setSenderPhone($senderPhone = null)
    {
        // validation for constraint: string
        if (!is_null($senderPhone) && !is_string($senderPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderPhone)), __LINE__);
        }
        $this->SenderPhone = $senderPhone;
        return $this;
    }
    /**
     * Get ExServiceCodes value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getExServiceCodes()
    {
        return $this->ExServiceCodes;
    }
    /**
     * Set ExServiceCodes value
     * @param \ArrayType\ArrayOfString $exServiceCodes
     * @return \StructType\BarcodeModel
     */
    public function setExServiceCodes(\ArrayType\ArrayOfString $exServiceCodes = null)
    {
        $this->ExServiceCodes = $exServiceCodes;
        return $this;
    }
    /**
     * Get WaybillDate value
     * @return string|null
     */
    public function getWaybillDate()
    {
        return $this->WaybillDate;
    }
    /**
     * Set WaybillDate value
     * @param string $waybillDate
     * @return \StructType\BarcodeModel
     */
    public function setWaybillDate($waybillDate = null)
    {
        // validation for constraint: string
        if (!is_null($waybillDate) && !is_string($waybillDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waybillDate)), __LINE__);
        }
        $this->WaybillDate = $waybillDate;
        return $this;
    }
    /**
     * Get LovDeliveryTypeName value
     * @return string|null
     */
    public function getLovDeliveryTypeName()
    {
        return $this->LovDeliveryTypeName;
    }
    /**
     * Set LovDeliveryTypeName value
     * @param string $lovDeliveryTypeName
     * @return \StructType\BarcodeModel
     */
    public function setLovDeliveryTypeName($lovDeliveryTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovDeliveryTypeName) && !is_string($lovDeliveryTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lovDeliveryTypeName)), __LINE__);
        }
        $this->LovDeliveryTypeName = $lovDeliveryTypeName;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\BarcodeModel
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \StructType\BarcodeModel
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BarcodeModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
