<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BATCHWAYBILL StructType
 * @subpackage Structs
 */
class BATCHWAYBILL extends AbstractStructBase
{
    /**
     * The BATCHWAYBILLID
     * @var string
     */
    public $BATCHWAYBILLID;
    /**
     * The LOVBATCHWAYBILLTYPEID
     * @var float
     */
    public $LOVBATCHWAYBILLTYPEID;
    /**
     * The ROUTEID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ROUTEID;
    /**
     * The SOURCEUNITID
     * @var float
     */
    public $SOURCEUNITID;
    /**
     * The TARGETUNITID
     * @var float
     */
    public $TARGETUNITID;
    /**
     * The SEAL_NUMBER1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $SEAL_NUMBER1;
    /**
     * The SEAL_NUMBER2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $SEAL_NUMBER2;
    /**
     * The CANCELED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $CANCELED;
    /**
     * The CANCEL_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CANCEL_DATE;
    /**
     * The CANCELEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CANCELEDBY;
    /**
     * The COURIEREMPLOYEEID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $COURIEREMPLOYEEID;
    /**
     * The DOCUMENT_SERIAL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $DOCUMENT_SERIAL;
    /**
     * The DOCUMENT_NUMBER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $DOCUMENT_NUMBER;
    /**
     * The PRINTED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $PRINTED;
    /**
     * The CANCELUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CANCELUNITID;
    /**
     * The CANCEL_DESCRIPTION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 256
     * @var string
     */
    public $CANCEL_DESCRIPTION;
    /**
     * The PRINT_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRINT_DATE;
    /**
     * The AUDIT_CREATE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDITCREATEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The AUDITMODIFIEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_DELETED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The APPLICATION_VERSION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The APPLICATIONID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The TTIBAGBARGODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $TTIBAGBARGODE;
    /**
     * The LOVBARCODEPRINTSTATUSID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LOVBARCODEPRINTSTATUSID;
    /**
     * The PRINTERBARCODEID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRINTERBARCODEID;
    /**
     * The ROUTE_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $ROUTE_CODE;
    /**
     * The BATCHWAYBILLTYPE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $BATCHWAYBILLTYPE;
    /**
     * The TRANSFER_STATUS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $TRANSFER_STATUS;
    /**
     * The TRANSFER_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TRANSFER_DATE;
    /**
     * Constructor method for BATCHWAYBILL
     * @uses BATCHWAYBILL::setBATCHWAYBILLID()
     * @uses BATCHWAYBILL::setLOVBATCHWAYBILLTYPEID()
     * @uses BATCHWAYBILL::setROUTEID()
     * @uses BATCHWAYBILL::setSOURCEUNITID()
     * @uses BATCHWAYBILL::setTARGETUNITID()
     * @uses BATCHWAYBILL::setSEAL_NUMBER1()
     * @uses BATCHWAYBILL::setSEAL_NUMBER2()
     * @uses BATCHWAYBILL::setCANCELED()
     * @uses BATCHWAYBILL::setCANCEL_DATE()
     * @uses BATCHWAYBILL::setCANCELEDBY()
     * @uses BATCHWAYBILL::setCOURIEREMPLOYEEID()
     * @uses BATCHWAYBILL::setDOCUMENT_SERIAL()
     * @uses BATCHWAYBILL::setDOCUMENT_NUMBER()
     * @uses BATCHWAYBILL::setPRINTED()
     * @uses BATCHWAYBILL::setCANCELUNITID()
     * @uses BATCHWAYBILL::setCANCEL_DESCRIPTION()
     * @uses BATCHWAYBILL::setPRINT_DATE()
     * @uses BATCHWAYBILL::setAUDIT_CREATE_DATE()
     * @uses BATCHWAYBILL::setAUDITCREATEDBY()
     * @uses BATCHWAYBILL::setAUDITCREATEUNITID()
     * @uses BATCHWAYBILL::setAUDIT_MODIFY_DATE()
     * @uses BATCHWAYBILL::setAUDITMODIFIEDBY()
     * @uses BATCHWAYBILL::setAUDITMODIFYUNITID()
     * @uses BATCHWAYBILL::setAUDIT_DELETED()
     * @uses BATCHWAYBILL::setAPPLICATION_VERSION()
     * @uses BATCHWAYBILL::setAPPLICATIONID()
     * @uses BATCHWAYBILL::setTTIBAGBARGODE()
     * @uses BATCHWAYBILL::setLOVBARCODEPRINTSTATUSID()
     * @uses BATCHWAYBILL::setPRINTERBARCODEID()
     * @uses BATCHWAYBILL::setROUTE_CODE()
     * @uses BATCHWAYBILL::setBATCHWAYBILLTYPE()
     * @uses BATCHWAYBILL::setTRANSFER_STATUS()
     * @uses BATCHWAYBILL::setTRANSFER_DATE()
     * @param string $bATCHWAYBILLID
     * @param float $lOVBATCHWAYBILLTYPEID
     * @param string $rOUTEID
     * @param float $sOURCEUNITID
     * @param float $tARGETUNITID
     * @param string $sEAL_NUMBER1
     * @param string $sEAL_NUMBER2
     * @param string $cANCELED
     * @param string $cANCEL_DATE
     * @param float $cANCELEDBY
     * @param float $cOURIEREMPLOYEEID
     * @param string $dOCUMENT_SERIAL
     * @param string $dOCUMENT_NUMBER
     * @param string $pRINTED
     * @param float $cANCELUNITID
     * @param string $cANCEL_DESCRIPTION
     * @param string $pRINT_DATE
     * @param string $aUDIT_CREATE_DATE
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param string $aUDIT_MODIFY_DATE
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_DELETED
     * @param string $aPPLICATION_VERSION
     * @param float $aPPLICATIONID
     * @param string $tTIBAGBARGODE
     * @param float $lOVBARCODEPRINTSTATUSID
     * @param string $pRINTERBARCODEID
     * @param string $rOUTE_CODE
     * @param string $bATCHWAYBILLTYPE
     * @param string $tRANSFER_STATUS
     * @param string $tRANSFER_DATE
     */
    public function __construct($bATCHWAYBILLID = null, $lOVBATCHWAYBILLTYPEID = null, $rOUTEID = null, $sOURCEUNITID = null, $tARGETUNITID = null, $sEAL_NUMBER1 = null, $sEAL_NUMBER2 = null, $cANCELED = null, $cANCEL_DATE = null, $cANCELEDBY = null, $cOURIEREMPLOYEEID = null, $dOCUMENT_SERIAL = null, $dOCUMENT_NUMBER = null, $pRINTED = null, $cANCELUNITID = null, $cANCEL_DESCRIPTION = null, $pRINT_DATE = null, $aUDIT_CREATE_DATE = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDIT_MODIFY_DATE = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_DELETED = null, $aPPLICATION_VERSION = null, $aPPLICATIONID = null, $tTIBAGBARGODE = null, $lOVBARCODEPRINTSTATUSID = null, $pRINTERBARCODEID = null, $rOUTE_CODE = null, $bATCHWAYBILLTYPE = null, $tRANSFER_STATUS = null, $tRANSFER_DATE = null)
    {
        $this
            ->setBATCHWAYBILLID($bATCHWAYBILLID)
            ->setLOVBATCHWAYBILLTYPEID($lOVBATCHWAYBILLTYPEID)
            ->setROUTEID($rOUTEID)
            ->setSOURCEUNITID($sOURCEUNITID)
            ->setTARGETUNITID($tARGETUNITID)
            ->setSEAL_NUMBER1($sEAL_NUMBER1)
            ->setSEAL_NUMBER2($sEAL_NUMBER2)
            ->setCANCELED($cANCELED)
            ->setCANCEL_DATE($cANCEL_DATE)
            ->setCANCELEDBY($cANCELEDBY)
            ->setCOURIEREMPLOYEEID($cOURIEREMPLOYEEID)
            ->setDOCUMENT_SERIAL($dOCUMENT_SERIAL)
            ->setDOCUMENT_NUMBER($dOCUMENT_NUMBER)
            ->setPRINTED($pRINTED)
            ->setCANCELUNITID($cANCELUNITID)
            ->setCANCEL_DESCRIPTION($cANCEL_DESCRIPTION)
            ->setPRINT_DATE($pRINT_DATE)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setTTIBAGBARGODE($tTIBAGBARGODE)
            ->setLOVBARCODEPRINTSTATUSID($lOVBARCODEPRINTSTATUSID)
            ->setPRINTERBARCODEID($pRINTERBARCODEID)
            ->setROUTE_CODE($rOUTE_CODE)
            ->setBATCHWAYBILLTYPE($bATCHWAYBILLTYPE)
            ->setTRANSFER_STATUS($tRANSFER_STATUS)
            ->setTRANSFER_DATE($tRANSFER_DATE);
    }
    /**
     * Get BATCHWAYBILLID value
     * @return string|null
     */
    public function getBATCHWAYBILLID()
    {
        return $this->BATCHWAYBILLID;
    }
    /**
     * Set BATCHWAYBILLID value
     * @param string $bATCHWAYBILLID
     * @return \StructType\BATCHWAYBILL
     */
    public function setBATCHWAYBILLID($bATCHWAYBILLID = null)
    {
        // validation for constraint: string
        if (!is_null($bATCHWAYBILLID) && !is_string($bATCHWAYBILLID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bATCHWAYBILLID)), __LINE__);
        }
        $this->BATCHWAYBILLID = $bATCHWAYBILLID;
        return $this;
    }
    /**
     * Get LOVBATCHWAYBILLTYPEID value
     * @return float|null
     */
    public function getLOVBATCHWAYBILLTYPEID()
    {
        return $this->LOVBATCHWAYBILLTYPEID;
    }
    /**
     * Set LOVBATCHWAYBILLTYPEID value
     * @param float $lOVBATCHWAYBILLTYPEID
     * @return \StructType\BATCHWAYBILL
     */
    public function setLOVBATCHWAYBILLTYPEID($lOVBATCHWAYBILLTYPEID = null)
    {
        $this->LOVBATCHWAYBILLTYPEID = $lOVBATCHWAYBILLTYPEID;
        return $this;
    }
    /**
     * Get ROUTEID value
     * @return string|null
     */
    public function getROUTEID()
    {
        return $this->ROUTEID;
    }
    /**
     * Set ROUTEID value
     * @param string $rOUTEID
     * @return \StructType\BATCHWAYBILL
     */
    public function setROUTEID($rOUTEID = null)
    {
        // validation for constraint: string
        if (!is_null($rOUTEID) && !is_string($rOUTEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rOUTEID)), __LINE__);
        }
        $this->ROUTEID = $rOUTEID;
        return $this;
    }
    /**
     * Get SOURCEUNITID value
     * @return float|null
     */
    public function getSOURCEUNITID()
    {
        return $this->SOURCEUNITID;
    }
    /**
     * Set SOURCEUNITID value
     * @param float $sOURCEUNITID
     * @return \StructType\BATCHWAYBILL
     */
    public function setSOURCEUNITID($sOURCEUNITID = null)
    {
        $this->SOURCEUNITID = $sOURCEUNITID;
        return $this;
    }
    /**
     * Get TARGETUNITID value
     * @return float|null
     */
    public function getTARGETUNITID()
    {
        return $this->TARGETUNITID;
    }
    /**
     * Set TARGETUNITID value
     * @param float $tARGETUNITID
     * @return \StructType\BATCHWAYBILL
     */
    public function setTARGETUNITID($tARGETUNITID = null)
    {
        $this->TARGETUNITID = $tARGETUNITID;
        return $this;
    }
    /**
     * Get SEAL_NUMBER1 value
     * @return string|null
     */
    public function getSEAL_NUMBER1()
    {
        return $this->SEAL_NUMBER1;
    }
    /**
     * Set SEAL_NUMBER1 value
     * @param string $sEAL_NUMBER1
     * @return \StructType\BATCHWAYBILL
     */
    public function setSEAL_NUMBER1($sEAL_NUMBER1 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sEAL_NUMBER1) && strlen($sEAL_NUMBER1) > 16) || (is_array($sEAL_NUMBER1) && count($sEAL_NUMBER1) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($sEAL_NUMBER1) ? strlen($sEAL_NUMBER1) : count($sEAL_NUMBER1)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sEAL_NUMBER1) && !is_string($sEAL_NUMBER1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEAL_NUMBER1)), __LINE__);
        }
        $this->SEAL_NUMBER1 = $sEAL_NUMBER1;
        return $this;
    }
    /**
     * Get SEAL_NUMBER2 value
     * @return string|null
     */
    public function getSEAL_NUMBER2()
    {
        return $this->SEAL_NUMBER2;
    }
    /**
     * Set SEAL_NUMBER2 value
     * @param string $sEAL_NUMBER2
     * @return \StructType\BATCHWAYBILL
     */
    public function setSEAL_NUMBER2($sEAL_NUMBER2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sEAL_NUMBER2) && strlen($sEAL_NUMBER2) > 16) || (is_array($sEAL_NUMBER2) && count($sEAL_NUMBER2) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($sEAL_NUMBER2) ? strlen($sEAL_NUMBER2) : count($sEAL_NUMBER2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sEAL_NUMBER2) && !is_string($sEAL_NUMBER2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEAL_NUMBER2)), __LINE__);
        }
        $this->SEAL_NUMBER2 = $sEAL_NUMBER2;
        return $this;
    }
    /**
     * Get CANCELED value
     * @return string|null
     */
    public function getCANCELED()
    {
        return $this->CANCELED;
    }
    /**
     * Set CANCELED value
     * @param string $cANCELED
     * @return \StructType\BATCHWAYBILL
     */
    public function setCANCELED($cANCELED = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cANCELED) && strlen($cANCELED) > 1) || (is_array($cANCELED) && count($cANCELED) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($cANCELED) ? strlen($cANCELED) : count($cANCELED)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cANCELED) && !is_string($cANCELED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cANCELED)), __LINE__);
        }
        $this->CANCELED = $cANCELED;
        return $this;
    }
    /**
     * Get CANCEL_DATE value
     * @return string|null
     */
    public function getCANCEL_DATE()
    {
        return $this->CANCEL_DATE;
    }
    /**
     * Set CANCEL_DATE value
     * @param string $cANCEL_DATE
     * @return \StructType\BATCHWAYBILL
     */
    public function setCANCEL_DATE($cANCEL_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($cANCEL_DATE) && !is_string($cANCEL_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cANCEL_DATE)), __LINE__);
        }
        $this->CANCEL_DATE = $cANCEL_DATE;
        return $this;
    }
    /**
     * Get CANCELEDBY value
     * @return float|null
     */
    public function getCANCELEDBY()
    {
        return $this->CANCELEDBY;
    }
    /**
     * Set CANCELEDBY value
     * @param float $cANCELEDBY
     * @return \StructType\BATCHWAYBILL
     */
    public function setCANCELEDBY($cANCELEDBY = null)
    {
        $this->CANCELEDBY = $cANCELEDBY;
        return $this;
    }
    /**
     * Get COURIEREMPLOYEEID value
     * @return float|null
     */
    public function getCOURIEREMPLOYEEID()
    {
        return $this->COURIEREMPLOYEEID;
    }
    /**
     * Set COURIEREMPLOYEEID value
     * @param float $cOURIEREMPLOYEEID
     * @return \StructType\BATCHWAYBILL
     */
    public function setCOURIEREMPLOYEEID($cOURIEREMPLOYEEID = null)
    {
        $this->COURIEREMPLOYEEID = $cOURIEREMPLOYEEID;
        return $this;
    }
    /**
     * Get DOCUMENT_SERIAL value
     * @return string|null
     */
    public function getDOCUMENT_SERIAL()
    {
        return $this->DOCUMENT_SERIAL;
    }
    /**
     * Set DOCUMENT_SERIAL value
     * @param string $dOCUMENT_SERIAL
     * @return \StructType\BATCHWAYBILL
     */
    public function setDOCUMENT_SERIAL($dOCUMENT_SERIAL = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dOCUMENT_SERIAL) && strlen($dOCUMENT_SERIAL) > 2) || (is_array($dOCUMENT_SERIAL) && count($dOCUMENT_SERIAL) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($dOCUMENT_SERIAL) ? strlen($dOCUMENT_SERIAL) : count($dOCUMENT_SERIAL)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dOCUMENT_SERIAL) && !is_string($dOCUMENT_SERIAL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dOCUMENT_SERIAL)), __LINE__);
        }
        $this->DOCUMENT_SERIAL = $dOCUMENT_SERIAL;
        return $this;
    }
    /**
     * Get DOCUMENT_NUMBER value
     * @return string|null
     */
    public function getDOCUMENT_NUMBER()
    {
        return $this->DOCUMENT_NUMBER;
    }
    /**
     * Set DOCUMENT_NUMBER value
     * @param string $dOCUMENT_NUMBER
     * @return \StructType\BATCHWAYBILL
     */
    public function setDOCUMENT_NUMBER($dOCUMENT_NUMBER = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dOCUMENT_NUMBER) && strlen($dOCUMENT_NUMBER) > 8) || (is_array($dOCUMENT_NUMBER) && count($dOCUMENT_NUMBER) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($dOCUMENT_NUMBER) ? strlen($dOCUMENT_NUMBER) : count($dOCUMENT_NUMBER)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dOCUMENT_NUMBER) && !is_string($dOCUMENT_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dOCUMENT_NUMBER)), __LINE__);
        }
        $this->DOCUMENT_NUMBER = $dOCUMENT_NUMBER;
        return $this;
    }
    /**
     * Get PRINTED value
     * @return string|null
     */
    public function getPRINTED()
    {
        return $this->PRINTED;
    }
    /**
     * Set PRINTED value
     * @param string $pRINTED
     * @return \StructType\BATCHWAYBILL
     */
    public function setPRINTED($pRINTED = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pRINTED) && strlen($pRINTED) > 1) || (is_array($pRINTED) && count($pRINTED) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($pRINTED) ? strlen($pRINTED) : count($pRINTED)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pRINTED) && !is_string($pRINTED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pRINTED)), __LINE__);
        }
        $this->PRINTED = $pRINTED;
        return $this;
    }
    /**
     * Get CANCELUNITID value
     * @return float|null
     */
    public function getCANCELUNITID()
    {
        return $this->CANCELUNITID;
    }
    /**
     * Set CANCELUNITID value
     * @param float $cANCELUNITID
     * @return \StructType\BATCHWAYBILL
     */
    public function setCANCELUNITID($cANCELUNITID = null)
    {
        $this->CANCELUNITID = $cANCELUNITID;
        return $this;
    }
    /**
     * Get CANCEL_DESCRIPTION value
     * @return string|null
     */
    public function getCANCEL_DESCRIPTION()
    {
        return $this->CANCEL_DESCRIPTION;
    }
    /**
     * Set CANCEL_DESCRIPTION value
     * @param string $cANCEL_DESCRIPTION
     * @return \StructType\BATCHWAYBILL
     */
    public function setCANCEL_DESCRIPTION($cANCEL_DESCRIPTION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cANCEL_DESCRIPTION) && strlen($cANCEL_DESCRIPTION) > 256) || (is_array($cANCEL_DESCRIPTION) && count($cANCEL_DESCRIPTION) > 256)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 256 element(s) or a scalar of 256 character(s) at most, "%d" length given', is_scalar($cANCEL_DESCRIPTION) ? strlen($cANCEL_DESCRIPTION) : count($cANCEL_DESCRIPTION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cANCEL_DESCRIPTION) && !is_string($cANCEL_DESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cANCEL_DESCRIPTION)), __LINE__);
        }
        $this->CANCEL_DESCRIPTION = $cANCEL_DESCRIPTION;
        return $this;
    }
    /**
     * Get PRINT_DATE value
     * @return string|null
     */
    public function getPRINT_DATE()
    {
        return $this->PRINT_DATE;
    }
    /**
     * Set PRINT_DATE value
     * @param string $pRINT_DATE
     * @return \StructType\BATCHWAYBILL
     */
    public function setPRINT_DATE($pRINT_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($pRINT_DATE) && !is_string($pRINT_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pRINT_DATE)), __LINE__);
        }
        $this->PRINT_DATE = $pRINT_DATE;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \StructType\BATCHWAYBILL
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \StructType\BATCHWAYBILL
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \StructType\BATCHWAYBILL
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \StructType\BATCHWAYBILL
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \StructType\BATCHWAYBILL
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \StructType\BATCHWAYBILL
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \StructType\BATCHWAYBILL
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aUDIT_DELETED) && strlen($aUDIT_DELETED) > 1) || (is_array($aUDIT_DELETED) && count($aUDIT_DELETED) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($aUDIT_DELETED) ? strlen($aUDIT_DELETED) : count($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \StructType\BATCHWAYBILL
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aPPLICATION_VERSION) && strlen($aPPLICATION_VERSION) > 16) || (is_array($aPPLICATION_VERSION) && count($aPPLICATION_VERSION) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($aPPLICATION_VERSION) ? strlen($aPPLICATION_VERSION) : count($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \StructType\BATCHWAYBILL
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get TTIBAGBARGODE value
     * @return string|null
     */
    public function getTTIBAGBARGODE()
    {
        return $this->TTIBAGBARGODE;
    }
    /**
     * Set TTIBAGBARGODE value
     * @param string $tTIBAGBARGODE
     * @return \StructType\BATCHWAYBILL
     */
    public function setTTIBAGBARGODE($tTIBAGBARGODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tTIBAGBARGODE) && strlen($tTIBAGBARGODE) > 32) || (is_array($tTIBAGBARGODE) && count($tTIBAGBARGODE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($tTIBAGBARGODE) ? strlen($tTIBAGBARGODE) : count($tTIBAGBARGODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tTIBAGBARGODE) && !is_string($tTIBAGBARGODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tTIBAGBARGODE)), __LINE__);
        }
        $this->TTIBAGBARGODE = $tTIBAGBARGODE;
        return $this;
    }
    /**
     * Get LOVBARCODEPRINTSTATUSID value
     * @return float|null
     */
    public function getLOVBARCODEPRINTSTATUSID()
    {
        return $this->LOVBARCODEPRINTSTATUSID;
    }
    /**
     * Set LOVBARCODEPRINTSTATUSID value
     * @param float $lOVBARCODEPRINTSTATUSID
     * @return \StructType\BATCHWAYBILL
     */
    public function setLOVBARCODEPRINTSTATUSID($lOVBARCODEPRINTSTATUSID = null)
    {
        $this->LOVBARCODEPRINTSTATUSID = $lOVBARCODEPRINTSTATUSID;
        return $this;
    }
    /**
     * Get PRINTERBARCODEID value
     * @return string|null
     */
    public function getPRINTERBARCODEID()
    {
        return $this->PRINTERBARCODEID;
    }
    /**
     * Set PRINTERBARCODEID value
     * @param string $pRINTERBARCODEID
     * @return \StructType\BATCHWAYBILL
     */
    public function setPRINTERBARCODEID($pRINTERBARCODEID = null)
    {
        // validation for constraint: string
        if (!is_null($pRINTERBARCODEID) && !is_string($pRINTERBARCODEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pRINTERBARCODEID)), __LINE__);
        }
        $this->PRINTERBARCODEID = $pRINTERBARCODEID;
        return $this;
    }
    /**
     * Get ROUTE_CODE value
     * @return string|null
     */
    public function getROUTE_CODE()
    {
        return $this->ROUTE_CODE;
    }
    /**
     * Set ROUTE_CODE value
     * @param string $rOUTE_CODE
     * @return \StructType\BATCHWAYBILL
     */
    public function setROUTE_CODE($rOUTE_CODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rOUTE_CODE) && strlen($rOUTE_CODE) > 32) || (is_array($rOUTE_CODE) && count($rOUTE_CODE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($rOUTE_CODE) ? strlen($rOUTE_CODE) : count($rOUTE_CODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rOUTE_CODE) && !is_string($rOUTE_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rOUTE_CODE)), __LINE__);
        }
        $this->ROUTE_CODE = $rOUTE_CODE;
        return $this;
    }
    /**
     * Get BATCHWAYBILLTYPE value
     * @return string|null
     */
    public function getBATCHWAYBILLTYPE()
    {
        return $this->BATCHWAYBILLTYPE;
    }
    /**
     * Set BATCHWAYBILLTYPE value
     * @param string $bATCHWAYBILLTYPE
     * @return \StructType\BATCHWAYBILL
     */
    public function setBATCHWAYBILLTYPE($bATCHWAYBILLTYPE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bATCHWAYBILLTYPE) && strlen($bATCHWAYBILLTYPE) > 1) || (is_array($bATCHWAYBILLTYPE) && count($bATCHWAYBILLTYPE) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($bATCHWAYBILLTYPE) ? strlen($bATCHWAYBILLTYPE) : count($bATCHWAYBILLTYPE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bATCHWAYBILLTYPE) && !is_string($bATCHWAYBILLTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bATCHWAYBILLTYPE)), __LINE__);
        }
        $this->BATCHWAYBILLTYPE = $bATCHWAYBILLTYPE;
        return $this;
    }
    /**
     * Get TRANSFER_STATUS value
     * @return string|null
     */
    public function getTRANSFER_STATUS()
    {
        return $this->TRANSFER_STATUS;
    }
    /**
     * Set TRANSFER_STATUS value
     * @param string $tRANSFER_STATUS
     * @return \StructType\BATCHWAYBILL
     */
    public function setTRANSFER_STATUS($tRANSFER_STATUS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($tRANSFER_STATUS) && strlen($tRANSFER_STATUS) > 1) || (is_array($tRANSFER_STATUS) && count($tRANSFER_STATUS) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($tRANSFER_STATUS) ? strlen($tRANSFER_STATUS) : count($tRANSFER_STATUS)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tRANSFER_STATUS) && !is_string($tRANSFER_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tRANSFER_STATUS)), __LINE__);
        }
        $this->TRANSFER_STATUS = $tRANSFER_STATUS;
        return $this;
    }
    /**
     * Get TRANSFER_DATE value
     * @return string|null
     */
    public function getTRANSFER_DATE()
    {
        return $this->TRANSFER_DATE;
    }
    /**
     * Set TRANSFER_DATE value
     * @param string $tRANSFER_DATE
     * @return \StructType\BATCHWAYBILL
     */
    public function setTRANSFER_DATE($tRANSFER_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSFER_DATE) && !is_string($tRANSFER_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tRANSFER_DATE)), __LINE__);
        }
        $this->TRANSFER_DATE = $tRANSFER_DATE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BATCHWAYBILL
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
