<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateInvoiceWaybillNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateInvoiceWaybillNumber $parameters
     * @return \StructType\UpdateInvoiceWaybillNumberResponse|bool
     */
    public function UpdateInvoiceWaybillNumber(\StructType\UpdateInvoiceWaybillNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateInvoiceWaybillNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateOrderPiecesVolume
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateOrderPiecesVolume $parameters
     * @return \StructType\UpdateOrderPiecesVolumeResponse|bool
     */
    public function UpdateOrderPiecesVolume(\StructType\UpdateOrderPiecesVolume $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateOrderPiecesVolume($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateInvoiceWaybillNumberResponse|\StructType\UpdateOrderPiecesVolumeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
