<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIncomingCargoInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfIncomingCargoInfo
 * @subpackage Arrays
 */
class ArrayOfIncomingCargoInfo extends AbstractStructArrayBase
{
    /**
     * The IncomingCargoInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IncomingCargoInfo[]
     */
    public $IncomingCargoInfo;
    /**
     * Constructor method for ArrayOfIncomingCargoInfo
     * @uses ArrayOfIncomingCargoInfo::setIncomingCargoInfo()
     * @param \StructType\IncomingCargoInfo[] $incomingCargoInfo
     */
    public function __construct(array $incomingCargoInfo = array())
    {
        $this
            ->setIncomingCargoInfo($incomingCargoInfo);
    }
    /**
     * Get IncomingCargoInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IncomingCargoInfo[]|null
     */
    public function getIncomingCargoInfo()
    {
        return isset($this->IncomingCargoInfo) ? $this->IncomingCargoInfo : null;
    }
    /**
     * Set IncomingCargoInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingCargoInfo[] $incomingCargoInfo
     * @return \ArrayType\ArrayOfIncomingCargoInfo
     */
    public function setIncomingCargoInfo(array $incomingCargoInfo = array())
    {
        foreach ($incomingCargoInfo as $arrayOfIncomingCargoInfoIncomingCargoInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfIncomingCargoInfoIncomingCargoInfoItem instanceof \StructType\IncomingCargoInfo) {
                throw new \InvalidArgumentException(sprintf('The IncomingCargoInfo property can only contain items of \StructType\IncomingCargoInfo, "%s" given', is_object($arrayOfIncomingCargoInfoIncomingCargoInfoItem) ? get_class($arrayOfIncomingCargoInfoIncomingCargoInfoItem) : gettype($arrayOfIncomingCargoInfoIncomingCargoInfoItem)), __LINE__);
            }
        }
        if (is_null($incomingCargoInfo) || (is_array($incomingCargoInfo) && empty($incomingCargoInfo))) {
            unset($this->IncomingCargoInfo);
        } else {
            $this->IncomingCargoInfo = $incomingCargoInfo;
        }
        return $this;
    }
    /**
     * Add item to IncomingCargoInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\IncomingCargoInfo $item
     * @return \ArrayType\ArrayOfIncomingCargoInfo
     */
    public function addToIncomingCargoInfo(\StructType\IncomingCargoInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IncomingCargoInfo) {
            throw new \InvalidArgumentException(sprintf('The IncomingCargoInfo property can only contain items of \StructType\IncomingCargoInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IncomingCargoInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IncomingCargoInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IncomingCargoInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IncomingCargoInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IncomingCargoInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IncomingCargoInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IncomingCargoInfo
     */
    public function getAttributeName()
    {
        return 'IncomingCargoInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIncomingCargoInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
