<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerAddress ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomerAddress
 * @subpackage Arrays
 */
class ArrayOfCustomerAddress extends AbstractStructArrayBase
{
    /**
     * The CustomerAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerAddress[]
     */
    public $CustomerAddress;
    /**
     * Constructor method for ArrayOfCustomerAddress
     * @uses ArrayOfCustomerAddress::setCustomerAddress()
     * @param \StructType\CustomerAddress[] $customerAddress
     */
    public function __construct(array $customerAddress = array())
    {
        $this
            ->setCustomerAddress($customerAddress);
    }
    /**
     * Get CustomerAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerAddress[]|null
     */
    public function getCustomerAddress()
    {
        return isset($this->CustomerAddress) ? $this->CustomerAddress : null;
    }
    /**
     * Set CustomerAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerAddress[] $customerAddress
     * @return \ArrayType\ArrayOfCustomerAddress
     */
    public function setCustomerAddress(array $customerAddress = array())
    {
        foreach ($customerAddress as $arrayOfCustomerAddressCustomerAddressItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerAddressCustomerAddressItem instanceof \StructType\CustomerAddress) {
                throw new \InvalidArgumentException(sprintf('The CustomerAddress property can only contain items of \StructType\CustomerAddress, "%s" given', is_object($arrayOfCustomerAddressCustomerAddressItem) ? get_class($arrayOfCustomerAddressCustomerAddressItem) : gettype($arrayOfCustomerAddressCustomerAddressItem)), __LINE__);
            }
        }
        if (is_null($customerAddress) || (is_array($customerAddress) && empty($customerAddress))) {
            unset($this->CustomerAddress);
        } else {
            $this->CustomerAddress = $customerAddress;
        }
        return $this;
    }
    /**
     * Add item to CustomerAddress value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerAddress $item
     * @return \ArrayType\ArrayOfCustomerAddress
     */
    public function addToCustomerAddress(\StructType\CustomerAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerAddress) {
            throw new \InvalidArgumentException(sprintf('The CustomerAddress property can only contain items of \StructType\CustomerAddress, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerAddress[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerAddress|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerAddress|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerAddress|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerAddress|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerAddress|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerAddress
     */
    public function getAttributeName()
    {
        return 'CustomerAddress';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
