<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddressResultDto ArrayType
 * @subpackage Arrays
 */
class ArrayOfAddressResultDto extends AbstractStructArrayBase
{
    /**
     * The AddressResultDto
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressResultDto[]
     */
    public $AddressResultDto;
    /**
     * Constructor method for ArrayOfAddressResultDto
     * @uses ArrayOfAddressResultDto::setAddressResultDto()
     * @param \StructType\AddressResultDto[] $addressResultDto
     */
    public function __construct(array $addressResultDto = array())
    {
        $this
            ->setAddressResultDto($addressResultDto);
    }
    /**
     * Get AddressResultDto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressResultDto[]|null
     */
    public function getAddressResultDto()
    {
        return isset($this->AddressResultDto) ? $this->AddressResultDto : null;
    }
    /**
     * Set AddressResultDto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AddressResultDto[] $addressResultDto
     * @return \ArrayType\ArrayOfAddressResultDto
     */
    public function setAddressResultDto(array $addressResultDto = array())
    {
        foreach ($addressResultDto as $arrayOfAddressResultDtoAddressResultDtoItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressResultDtoAddressResultDtoItem instanceof \StructType\AddressResultDto) {
                throw new \InvalidArgumentException(sprintf('The AddressResultDto property can only contain items of \StructType\AddressResultDto, "%s" given', is_object($arrayOfAddressResultDtoAddressResultDtoItem) ? get_class($arrayOfAddressResultDtoAddressResultDtoItem) : gettype($arrayOfAddressResultDtoAddressResultDtoItem)), __LINE__);
            }
        }
        if (is_null($addressResultDto) || (is_array($addressResultDto) && empty($addressResultDto))) {
            unset($this->AddressResultDto);
        } else {
            $this->AddressResultDto = $addressResultDto;
        }
        return $this;
    }
    /**
     * Add item to AddressResultDto value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressResultDto $item
     * @return \ArrayType\ArrayOfAddressResultDto
     */
    public function addToAddressResultDto(\StructType\AddressResultDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressResultDto) {
            throw new \InvalidArgumentException(sprintf('The AddressResultDto property can only contain items of \StructType\AddressResultDto, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressResultDto[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AddressResultDto|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AddressResultDto|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AddressResultDto|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AddressResultDto|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AddressResultDto|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddressResultDto
     */
    public function getAttributeName()
    {
        return 'AddressResultDto';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAddressResultDto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
