<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA11 StructType
 * @subpackage Structs
 */
class WEBCARGODATA11 extends AbstractStructBase
{
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $CODE;
    /**
     * The SERI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 2
     * @var string
     */
    public $SERI;
    /**
     * The IRSNO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 8
     * @var string
     */
    public $IRSNO;
    /**
     * The REFNO
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $REFNO;
    /**
     * The MOK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $MOK;
    /**
     * The CIKIS_SUBESI
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBESI;
    /**
     * The VARIS_SUBESI
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBESI;
    /**
     * The ALICI_ADI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $ALICI_ADI;
    /**
     * The SEHIR
     * Meta informations extracted from the WSDL
     * - maxLength: 64
     * @var string
     */
    public $SEHIR;
    /**
     * The GONDERICI_ADI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $GONDERICI_ADI;
    /**
     * The TUTAR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The ADET
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ADET;
    /**
     * The DESI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * The IADE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 5
     * @var string
     */
    public $IADE;
    /**
     * The TARIH
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TARIH;
    /**
     * Constructor method for WEBCARGODATA11
     * @uses WEBCARGODATA11::setNAME()
     * @uses WEBCARGODATA11::setCODE()
     * @uses WEBCARGODATA11::setSERI()
     * @uses WEBCARGODATA11::setIRSNO()
     * @uses WEBCARGODATA11::setREFNO()
     * @uses WEBCARGODATA11::setMOK()
     * @uses WEBCARGODATA11::setCIKIS_SUBESI()
     * @uses WEBCARGODATA11::setVARIS_SUBESI()
     * @uses WEBCARGODATA11::setALICI_ADI()
     * @uses WEBCARGODATA11::setSEHIR()
     * @uses WEBCARGODATA11::setGONDERICI_ADI()
     * @uses WEBCARGODATA11::setTUTAR()
     * @uses WEBCARGODATA11::setADET()
     * @uses WEBCARGODATA11::setDESI()
     * @uses WEBCARGODATA11::setIADE()
     * @uses WEBCARGODATA11::setTARIH()
     * @param string $nAME
     * @param string $cODE
     * @param string $sERI
     * @param string $iRSNO
     * @param string $rEFNO
     * @param string $mOK
     * @param string $cIKIS_SUBESI
     * @param string $vARIS_SUBESI
     * @param string $aLICI_ADI
     * @param string $sEHIR
     * @param string $gONDERICI_ADI
     * @param float $tUTAR
     * @param float $aDET
     * @param float $dESI
     * @param string $iADE
     * @param string $tARIH
     */
    public function __construct($nAME = null, $cODE = null, $sERI = null, $iRSNO = null, $rEFNO = null, $mOK = null, $cIKIS_SUBESI = null, $vARIS_SUBESI = null, $aLICI_ADI = null, $sEHIR = null, $gONDERICI_ADI = null, $tUTAR = null, $aDET = null, $dESI = null, $iADE = null, $tARIH = null)
    {
        $this
            ->setNAME($nAME)
            ->setCODE($cODE)
            ->setSERI($sERI)
            ->setIRSNO($iRSNO)
            ->setREFNO($rEFNO)
            ->setMOK($mOK)
            ->setCIKIS_SUBESI($cIKIS_SUBESI)
            ->setVARIS_SUBESI($vARIS_SUBESI)
            ->setALICI_ADI($aLICI_ADI)
            ->setSEHIR($sEHIR)
            ->setGONDERICI_ADI($gONDERICI_ADI)
            ->setTUTAR($tUTAR)
            ->setADET($aDET)
            ->setDESI($dESI)
            ->setIADE($iADE)
            ->setTARIH($tARIH);
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\WEBCARGODATA11
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nAME) && strlen($nAME) > 128) || (is_array($nAME) && count($nAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($nAME) ? strlen($nAME) : count($nAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \StructType\WEBCARGODATA11
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cODE) && strlen($cODE) > 8) || (is_array($cODE) && count($cODE) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($cODE) ? strlen($cODE) : count($cODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \StructType\WEBCARGODATA11
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sERI) && strlen($sERI) > 2) || (is_array($sERI) && count($sERI) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($sERI) ? strlen($sERI) : count($sERI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get IRSNO value
     * @return string|null
     */
    public function getIRSNO()
    {
        return $this->IRSNO;
    }
    /**
     * Set IRSNO value
     * @param string $iRSNO
     * @return \StructType\WEBCARGODATA11
     */
    public function setIRSNO($iRSNO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iRSNO) && strlen($iRSNO) > 8) || (is_array($iRSNO) && count($iRSNO) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($iRSNO) ? strlen($iRSNO) : count($iRSNO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iRSNO) && !is_string($iRSNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iRSNO)), __LINE__);
        }
        $this->IRSNO = $iRSNO;
        return $this;
    }
    /**
     * Get REFNO value
     * @return string|null
     */
    public function getREFNO()
    {
        return $this->REFNO;
    }
    /**
     * Set REFNO value
     * @param string $rEFNO
     * @return \StructType\WEBCARGODATA11
     */
    public function setREFNO($rEFNO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rEFNO) && strlen($rEFNO) > 16) || (is_array($rEFNO) && count($rEFNO) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($rEFNO) ? strlen($rEFNO) : count($rEFNO)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rEFNO) && !is_string($rEFNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rEFNO)), __LINE__);
        }
        $this->REFNO = $rEFNO;
        return $this;
    }
    /**
     * Get MOK value
     * @return string|null
     */
    public function getMOK()
    {
        return $this->MOK;
    }
    /**
     * Set MOK value
     * @param string $mOK
     * @return \StructType\WEBCARGODATA11
     */
    public function setMOK($mOK = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mOK) && strlen($mOK) > 32) || (is_array($mOK) && count($mOK) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($mOK) ? strlen($mOK) : count($mOK)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mOK) && !is_string($mOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mOK)), __LINE__);
        }
        $this->MOK = $mOK;
        return $this;
    }
    /**
     * Get CIKIS_SUBESI value
     * @return string|null
     */
    public function getCIKIS_SUBESI()
    {
        return $this->CIKIS_SUBESI;
    }
    /**
     * Set CIKIS_SUBESI value
     * @param string $cIKIS_SUBESI
     * @return \StructType\WEBCARGODATA11
     */
    public function setCIKIS_SUBESI($cIKIS_SUBESI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cIKIS_SUBESI) && strlen($cIKIS_SUBESI) > 32) || (is_array($cIKIS_SUBESI) && count($cIKIS_SUBESI) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($cIKIS_SUBESI) ? strlen($cIKIS_SUBESI) : count($cIKIS_SUBESI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cIKIS_SUBESI) && !is_string($cIKIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cIKIS_SUBESI)), __LINE__);
        }
        $this->CIKIS_SUBESI = $cIKIS_SUBESI;
        return $this;
    }
    /**
     * Get VARIS_SUBESI value
     * @return string|null
     */
    public function getVARIS_SUBESI()
    {
        return $this->VARIS_SUBESI;
    }
    /**
     * Set VARIS_SUBESI value
     * @param string $vARIS_SUBESI
     * @return \StructType\WEBCARGODATA11
     */
    public function setVARIS_SUBESI($vARIS_SUBESI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vARIS_SUBESI) && strlen($vARIS_SUBESI) > 32) || (is_array($vARIS_SUBESI) && count($vARIS_SUBESI) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($vARIS_SUBESI) ? strlen($vARIS_SUBESI) : count($vARIS_SUBESI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vARIS_SUBESI) && !is_string($vARIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vARIS_SUBESI)), __LINE__);
        }
        $this->VARIS_SUBESI = $vARIS_SUBESI;
        return $this;
    }
    /**
     * Get ALICI_ADI value
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }
    /**
     * Set ALICI_ADI value
     * @param string $aLICI_ADI
     * @return \StructType\WEBCARGODATA11
     */
    public function setALICI_ADI($aLICI_ADI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aLICI_ADI) && strlen($aLICI_ADI) > 128) || (is_array($aLICI_ADI) && count($aLICI_ADI) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($aLICI_ADI) ? strlen($aLICI_ADI) : count($aLICI_ADI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aLICI_ADI) && !is_string($aLICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aLICI_ADI)), __LINE__);
        }
        $this->ALICI_ADI = $aLICI_ADI;
        return $this;
    }
    /**
     * Get SEHIR value
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }
    /**
     * Set SEHIR value
     * @param string $sEHIR
     * @return \StructType\WEBCARGODATA11
     */
    public function setSEHIR($sEHIR = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sEHIR) && strlen($sEHIR) > 64) || (is_array($sEHIR) && count($sEHIR) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($sEHIR) ? strlen($sEHIR) : count($sEHIR)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sEHIR) && !is_string($sEHIR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sEHIR)), __LINE__);
        }
        $this->SEHIR = $sEHIR;
        return $this;
    }
    /**
     * Get GONDERICI_ADI value
     * @return string|null
     */
    public function getGONDERICI_ADI()
    {
        return $this->GONDERICI_ADI;
    }
    /**
     * Set GONDERICI_ADI value
     * @param string $gONDERICI_ADI
     * @return \StructType\WEBCARGODATA11
     */
    public function setGONDERICI_ADI($gONDERICI_ADI = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($gONDERICI_ADI) && strlen($gONDERICI_ADI) > 128) || (is_array($gONDERICI_ADI) && count($gONDERICI_ADI) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($gONDERICI_ADI) ? strlen($gONDERICI_ADI) : count($gONDERICI_ADI)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gONDERICI_ADI) && !is_string($gONDERICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gONDERICI_ADI)), __LINE__);
        }
        $this->GONDERICI_ADI = $gONDERICI_ADI;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \StructType\WEBCARGODATA11
     */
    public function setTUTAR($tUTAR = null)
    {
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get ADET value
     * @return float|null
     */
    public function getADET()
    {
        return $this->ADET;
    }
    /**
     * Set ADET value
     * @param float $aDET
     * @return \StructType\WEBCARGODATA11
     */
    public function setADET($aDET = null)
    {
        $this->ADET = $aDET;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \StructType\WEBCARGODATA11
     */
    public function setDESI($dESI = null)
    {
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Get IADE value
     * @return string|null
     */
    public function getIADE()
    {
        return $this->IADE;
    }
    /**
     * Set IADE value
     * @param string $iADE
     * @return \StructType\WEBCARGODATA11
     */
    public function setIADE($iADE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iADE) && strlen($iADE) > 5) || (is_array($iADE) && count($iADE) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($iADE) ? strlen($iADE) : count($iADE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iADE) && !is_string($iADE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iADE)), __LINE__);
        }
        $this->IADE = $iADE;
        return $this;
    }
    /**
     * Get TARIH value
     * @return string|null
     */
    public function getTARIH()
    {
        return $this->TARIH;
    }
    /**
     * Set TARIH value
     * @param string $tARIH
     * @return \StructType\WEBCARGODATA11
     */
    public function setTARIH($tARIH = null)
    {
        // validation for constraint: string
        if (!is_null($tARIH) && !is_string($tARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tARIH)), __LINE__);
        }
        $this->TARIH = $tARIH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WEBCARGODATA11
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
