<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UNIT StructType
 * @subpackage Structs
 */
class UNIT extends AbstractStructBase
{
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The CODE
     * Meta informations extracted from the WSDL
     * - maxLength: 8
     * @var string
     */
    public $CODE;
    /**
     * The UNITID
     * @var float
     */
    public $UNITID;
    /**
     * Constructor method for UNIT
     * @uses UNIT::setNAME()
     * @uses UNIT::setCODE()
     * @uses UNIT::setUNITID()
     * @param string $nAME
     * @param string $cODE
     * @param float $uNITID
     */
    public function __construct($nAME = null, $cODE = null, $uNITID = null)
    {
        $this
            ->setNAME($nAME)
            ->setCODE($cODE)
            ->setUNITID($uNITID);
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\UNIT
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nAME) && strlen($nAME) > 128) || (is_array($nAME) && count($nAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($nAME) ? strlen($nAME) : count($nAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \StructType\UNIT
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($cODE) && strlen($cODE) > 8) || (is_array($cODE) && count($cODE) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($cODE) ? strlen($cODE) : count($cODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get UNITID value
     * @return float|null
     */
    public function getUNITID()
    {
        return $this->UNITID;
    }
    /**
     * Set UNITID value
     * @param float $uNITID
     * @return \StructType\UNIT
     */
    public function setUNITID($uNITID = null)
    {
        $this->UNITID = $uNITID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UNIT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
