<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIRECTION StructType
 * @subpackage Structs
 */
class DIRECTION extends AbstractStructBase
{
    /**
     * The DIRECTIONID
     * @var float
     */
    public $DIRECTIONID;
    /**
     * The NAME
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The SHORT_CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $SHORT_CODE;
    /**
     * The AUDIT_CREATE_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDITCREATEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The AUDITMODIFIEDBY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_DELETED
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The APPLICATION_VERSION
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The APPLICATIONID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The CODE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CODE;
    /**
     * Constructor method for DIRECTION
     * @uses DIRECTION::setDIRECTIONID()
     * @uses DIRECTION::setNAME()
     * @uses DIRECTION::setSHORT_CODE()
     * @uses DIRECTION::setAUDIT_CREATE_DATE()
     * @uses DIRECTION::setAUDITCREATEDBY()
     * @uses DIRECTION::setAUDITCREATEUNITID()
     * @uses DIRECTION::setAUDIT_MODIFY_DATE()
     * @uses DIRECTION::setAUDITMODIFIEDBY()
     * @uses DIRECTION::setAUDITMODIFYUNITID()
     * @uses DIRECTION::setAUDIT_DELETED()
     * @uses DIRECTION::setAPPLICATION_VERSION()
     * @uses DIRECTION::setAPPLICATIONID()
     * @uses DIRECTION::setCODE()
     * @param float $dIRECTIONID
     * @param string $nAME
     * @param string $sHORT_CODE
     * @param string $aUDIT_CREATE_DATE
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param string $aUDIT_MODIFY_DATE
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_DELETED
     * @param string $aPPLICATION_VERSION
     * @param float $aPPLICATIONID
     * @param float $cODE
     */
    public function __construct($dIRECTIONID = null, $nAME = null, $sHORT_CODE = null, $aUDIT_CREATE_DATE = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDIT_MODIFY_DATE = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_DELETED = null, $aPPLICATION_VERSION = null, $aPPLICATIONID = null, $cODE = null)
    {
        $this
            ->setDIRECTIONID($dIRECTIONID)
            ->setNAME($nAME)
            ->setSHORT_CODE($sHORT_CODE)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setCODE($cODE);
    }
    /**
     * Get DIRECTIONID value
     * @return float|null
     */
    public function getDIRECTIONID()
    {
        return $this->DIRECTIONID;
    }
    /**
     * Set DIRECTIONID value
     * @param float $dIRECTIONID
     * @return \StructType\DIRECTION
     */
    public function setDIRECTIONID($dIRECTIONID = null)
    {
        $this->DIRECTIONID = $dIRECTIONID;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \StructType\DIRECTION
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nAME) && strlen($nAME) > 128) || (is_array($nAME) && count($nAME) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($nAME) ? strlen($nAME) : count($nAME)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get SHORT_CODE value
     * @return string|null
     */
    public function getSHORT_CODE()
    {
        return $this->SHORT_CODE;
    }
    /**
     * Set SHORT_CODE value
     * @param string $sHORT_CODE
     * @return \StructType\DIRECTION
     */
    public function setSHORT_CODE($sHORT_CODE = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sHORT_CODE) && strlen($sHORT_CODE) > 32) || (is_array($sHORT_CODE) && count($sHORT_CODE) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($sHORT_CODE) ? strlen($sHORT_CODE) : count($sHORT_CODE)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sHORT_CODE) && !is_string($sHORT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sHORT_CODE)), __LINE__);
        }
        $this->SHORT_CODE = $sHORT_CODE;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \StructType\DIRECTION
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \StructType\DIRECTION
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \StructType\DIRECTION
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \StructType\DIRECTION
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \StructType\DIRECTION
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \StructType\DIRECTION
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \StructType\DIRECTION
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aUDIT_DELETED) && strlen($aUDIT_DELETED) > 1) || (is_array($aUDIT_DELETED) && count($aUDIT_DELETED) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($aUDIT_DELETED) ? strlen($aUDIT_DELETED) : count($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \StructType\DIRECTION
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aPPLICATION_VERSION) && strlen($aPPLICATION_VERSION) > 16) || (is_array($aPPLICATION_VERSION) && count($aPPLICATION_VERSION) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($aPPLICATION_VERSION) ? strlen($aPPLICATION_VERSION) : count($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \StructType\DIRECTION
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get CODE value
     * @return float|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param float $cODE
     * @return \StructType\DIRECTION
     */
    public function setCODE($cODE = null)
    {
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DIRECTION
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
