<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAddressList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressList $parameters
     * @return \StructType\GetAddressListResponse|bool
     */
    public function GetAddressList(\StructType\GetAddressList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAddressList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUndeliveredCargoSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUndeliveredCargoSearch $parameters
     * @return \StructType\GetUndeliveredCargoSearchResponse|bool
     */
    public function GetUndeliveredCargoSearch(\StructType\GetUndeliveredCargoSearch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUndeliveredCargoSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWaitingCargoList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWaitingCargoList $parameters
     * @return \StructType\GetWaitingCargoListResponse|bool
     */
    public function GetWaitingCargoList(\StructType\GetWaitingCargoList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWaitingCargoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryList $parameters
     * @return \StructType\GetDeliveryListResponse|bool
     */
    public function GetDeliveryList(\StructType\GetDeliveryList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDeliveryList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoSendList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoSendList $parameters
     * @return \StructType\GetCargoSendListResponse|bool
     */
    public function GetCargoSendList(\StructType\GetCargoSendList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoSendList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParentUnitAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetParentUnitAddress $parameters
     * @return \StructType\GetParentUnitAddressResponse|bool
     */
    public function GetParentUnitAddress(\StructType\GetParentUnitAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetParentUnitAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnitAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnitAddress $parameters
     * @return \StructType\GetUnitAddressResponse|bool
     */
    public function GetUnitAddress(\StructType\GetUnitAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUnitAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnitCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnitCard $parameters
     * @return \StructType\GetUnitCardResponse|bool
     */
    public function GetUnitCard(\StructType\GetUnitCard $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUnitCard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDuration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDuration $parameters
     * @return \StructType\GetDurationResponse|bool
     */
    public function GetDuration(\StructType\GetDuration $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDuration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryList2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryList2 $parameters
     * @return \StructType\GetDeliveryList2Response|bool
     */
    public function GetDeliveryList2(\StructType\GetDeliveryList2 $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDeliveryList2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoPieceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoPieceList $parameters
     * @return \StructType\GetCargoPieceListResponse|bool
     */
    public function GetCargoPieceList(\StructType\GetCargoPieceList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoPieceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPriceCalculation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPriceCalculation $parameters
     * @return \StructType\GetPriceCalculationResponse|bool
     */
    public function GetPriceCalculation(\StructType\GetPriceCalculation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPriceCalculation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServiceList $parameters
     * @return \StructType\GetServiceListResponse|bool
     */
    public function GetServiceList(\StructType\GetServiceList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServiceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServiceType $parameters
     * @return \StructType\GetServiceTypeResponse|bool
     */
    public function GetServiceType(\StructType\GetServiceType $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetServiceType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRedirectionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRedirectionList $parameters
     * @return \StructType\GetRedirectionListResponse|bool
     */
    public function GetRedirectionList(\StructType\GetRedirectionList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRedirectionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBackList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBackList $parameters
     * @return \StructType\GetBackListResponse|bool
     */
    public function GetBackList(\StructType\GetBackList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBackList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoReturn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoReturn $parameters
     * @return \StructType\GetCargoReturnResponse|bool
     */
    public function GetCargoReturn(\StructType\GetCargoReturn $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoReturn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoInfo $parameters
     * @return \StructType\GetCargoInfoResponse|bool
     */
    public function GetCargoInfo(\StructType\GetCargoInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCityList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCityList $parameters
     * @return \StructType\GetCityListResponse|bool
     */
    public function GetCityList(\StructType\GetCityList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCityList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTown
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTown $parameters
     * @return \StructType\GetTownResponse|bool
     */
    public function GetTown(\StructType\GetTown $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTown($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnit $parameters
     * @return \StructType\GetUnitResponse|bool
     */
    public function GetUnit(\StructType\GetUnit $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUnit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnitBranch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUnitBranch $parameters
     * @return \StructType\GetUnitBranchResponse|bool
     */
    public function GetUnitBranch(\StructType\GetUnitBranch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetUnitBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegions $parameters
     * @return \StructType\GetRegionsResponse|bool
     */
    public function GetRegions(\StructType\GetRegions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRegions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoSearch $parameters
     * @return \StructType\GetCargoSearchResponse|bool
     */
    public function GetCargoSearch(\StructType\GetCargoSearch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoSearchByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoSearchByCode $parameters
     * @return \StructType\GetCargoSearchByCodeResponse|bool
     */
    public function GetCargoSearchByCode(\StructType\GetCargoSearchByCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoSearchByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSortedCargoInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSortedCargoInfo $parameters
     * @return \StructType\GetSortedCargoInfoResponse|bool
     */
    public function GetSortedCargoInfo(\StructType\GetSortedCargoInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSortedCargoInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoTransaction $parameters
     * @return \StructType\GetCargoTransactionResponse|bool
     */
    public function GetCargoTransaction(\StructType\GetCargoTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoTransactionByWaybillId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCargoTransactionByWaybillId $parameters
     * @return \StructType\GetCargoTransactionByWaybillIdResponse|bool
     */
    public function GetCargoTransactionByWaybillId(\StructType\GetCargoTransactionByWaybillId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCargoTransactionByWaybillId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDispatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDispatch $parameters
     * @return \StructType\GetDispatchResponse|bool
     */
    public function GetDispatch(\StructType\GetDispatch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDispatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrder $parameters
     * @return \StructType\GetOrderResponse|bool
     */
    public function GetOrder(\StructType\GetOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDispatchWithIntegrationCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDispatchWithIntegrationCode $parameters
     * @return \StructType\GetDispatchWithIntegrationCodeResponse|bool
     */
    public function GetDispatchWithIntegrationCode(\StructType\GetDispatchWithIntegrationCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDispatchWithIntegrationCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderWithIntegrationCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderWithIntegrationCode $parameters
     * @return \StructType\GetOrderWithIntegrationCodeResponse|bool
     */
    public function GetOrderWithIntegrationCode(\StructType\GetOrderWithIntegrationCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOrderWithIntegrationCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCancelNewDoc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCancelNewDoc $parameters
     * @return \StructType\GetCancelNewDocResponse|bool
     */
    public function GetCancelNewDoc(\StructType\GetCancelNewDoc $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCancelNewDoc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryInfo $parameters
     * @return \StructType\GetDeliveryInfoResponse|bool
     */
    public function GetDeliveryInfo(\StructType\GetDeliveryInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDeliveryInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMissingNewDoc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMissingNewDoc $parameters
     * @return \StructType\GetMissingNewDocResponse|bool
     */
    public function GetMissingNewDoc(\StructType\GetMissingNewDoc $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMissingNewDoc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryInfodocID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryInfodocID $parameters
     * @return \StructType\GetDeliveryInfodocIDResponse|bool
     */
    public function GetDeliveryInfodocID(\StructType\GetDeliveryInfodocID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDeliveryInfodocID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncomingCargoInfoBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIncomingCargoInfoBarcode $parameters
     * @return \StructType\GetIncomingCargoInfoBarcodeResponse|bool
     */
    public function GetIncomingCargoInfoBarcode(\StructType\GetIncomingCargoInfoBarcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetIncomingCargoInfoBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBarcode $parameters
     * @return \StructType\GetBarcodeResponse|bool
     */
    public function GetBarcode(\StructType\GetBarcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAddressListResponse|\StructType\GetBackListResponse|\StructType\GetBarcodeResponse|\StructType\GetCancelNewDocResponse|\StructType\GetCargoInfoResponse|\StructType\GetCargoPieceListResponse|\StructType\GetCargoReturnResponse|\StructType\GetCargoSearchByCodeResponse|\StructType\GetCargoSearchResponse|\StructType\GetCargoSendListResponse|\StructType\GetCargoTransactionByWaybillIdResponse|\StructType\GetCargoTransactionResponse|\StructType\GetCityListResponse|\StructType\GetDeliveryInfodocIDResponse|\StructType\GetDeliveryInfoResponse|\StructType\GetDeliveryList2Response|\StructType\GetDeliveryListResponse|\StructType\GetDispatchResponse|\StructType\GetDispatchWithIntegrationCodeResponse|\StructType\GetDurationResponse|\StructType\GetIncomingCargoInfoBarcodeResponse|\StructType\GetMissingNewDocResponse|\StructType\GetOrderResponse|\StructType\GetOrderWithIntegrationCodeResponse|\StructType\GetParentUnitAddressResponse|\StructType\GetPriceCalculationResponse|\StructType\GetRedirectionListResponse|\StructType\GetRegionsResponse|\StructType\GetServiceListResponse|\StructType\GetServiceTypeResponse|\StructType\GetSortedCargoInfoResponse|\StructType\GetTownResponse|\StructType\GetUndeliveredCargoSearchResponse|\StructType\GetUnitAddressResponse|\StructType\GetUnitBranchResponse|\StructType\GetUnitCardResponse|\StructType\GetUnitResponse|\StructType\GetWaitingCargoListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
