<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShippingOrder ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfShippingOrder
 * @subpackage Arrays
 */
class ArrayOfShippingOrder extends AbstractStructArrayBase
{
    /**
     * The ShippingOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ShippingOrder[]
     */
    public $ShippingOrder;
    /**
     * Constructor method for ArrayOfShippingOrder
     * @uses ArrayOfShippingOrder::setShippingOrder()
     * @param \StructType\ShippingOrder[] $shippingOrder
     */
    public function __construct(array $shippingOrder = array())
    {
        $this
            ->setShippingOrder($shippingOrder);
    }
    /**
     * Get ShippingOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ShippingOrder[]|null
     */
    public function getShippingOrder()
    {
        return isset($this->ShippingOrder) ? $this->ShippingOrder : null;
    }
    /**
     * Set ShippingOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOrder[] $shippingOrder
     * @return \ArrayType\ArrayOfShippingOrder
     */
    public function setShippingOrder(array $shippingOrder = array())
    {
        foreach ($shippingOrder as $arrayOfShippingOrderShippingOrderItem) {
            // validation for constraint: itemType
            if (!$arrayOfShippingOrderShippingOrderItem instanceof \StructType\ShippingOrder) {
                throw new \InvalidArgumentException(sprintf('The ShippingOrder property can only contain items of \StructType\ShippingOrder, "%s" given', is_object($arrayOfShippingOrderShippingOrderItem) ? get_class($arrayOfShippingOrderShippingOrderItem) : gettype($arrayOfShippingOrderShippingOrderItem)), __LINE__);
            }
        }
        if (is_null($shippingOrder) || (is_array($shippingOrder) && empty($shippingOrder))) {
            unset($this->ShippingOrder);
        } else {
            $this->ShippingOrder = $shippingOrder;
        }
        return $this;
    }
    /**
     * Add item to ShippingOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\ShippingOrder $item
     * @return \ArrayType\ArrayOfShippingOrder
     */
    public function addToShippingOrder(\StructType\ShippingOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShippingOrder) {
            throw new \InvalidArgumentException(sprintf('The ShippingOrder property can only contain items of \StructType\ShippingOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShippingOrder[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ShippingOrder|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ShippingOrder|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ShippingOrder|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ShippingOrder|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ShippingOrder|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShippingOrder
     */
    public function getAttributeName()
    {
        return 'ShippingOrder';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfShippingOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
