<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPieceDetail ArrayType
 * @subpackage Arrays
 */
class ArrayOfPieceDetail extends AbstractStructArrayBase
{
    /**
     * The PieceDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PieceDetail[]
     */
    public $PieceDetail;
    /**
     * Constructor method for ArrayOfPieceDetail
     * @uses ArrayOfPieceDetail::setPieceDetail()
     * @param \StructType\PieceDetail[] $pieceDetail
     */
    public function __construct(array $pieceDetail = array())
    {
        $this
            ->setPieceDetail($pieceDetail);
    }
    /**
     * Get PieceDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PieceDetail[]|null
     */
    public function getPieceDetail()
    {
        return isset($this->PieceDetail) ? $this->PieceDetail : null;
    }
    /**
     * Set PieceDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PieceDetail[] $pieceDetail
     * @return \ArrayType\ArrayOfPieceDetail
     */
    public function setPieceDetail(array $pieceDetail = array())
    {
        foreach ($pieceDetail as $arrayOfPieceDetailPieceDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfPieceDetailPieceDetailItem instanceof \StructType\PieceDetail) {
                throw new \InvalidArgumentException(sprintf('The PieceDetail property can only contain items of \StructType\PieceDetail, "%s" given', is_object($arrayOfPieceDetailPieceDetailItem) ? get_class($arrayOfPieceDetailPieceDetailItem) : gettype($arrayOfPieceDetailPieceDetailItem)), __LINE__);
            }
        }
        if (is_null($pieceDetail) || (is_array($pieceDetail) && empty($pieceDetail))) {
            unset($this->PieceDetail);
        } else {
            $this->PieceDetail = $pieceDetail;
        }
        return $this;
    }
    /**
     * Add item to PieceDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\PieceDetail $item
     * @return \ArrayType\ArrayOfPieceDetail
     */
    public function addToPieceDetail(\StructType\PieceDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PieceDetail) {
            throw new \InvalidArgumentException(sprintf('The PieceDetail property can only contain items of \StructType\PieceDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PieceDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PieceDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PieceDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PieceDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PieceDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PieceDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PieceDetail
     */
    public function getAttributeName()
    {
        return 'PieceDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPieceDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
