<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBase64Binary ArrayType
 * @subpackage Arrays
 */
class ArrayOfBase64Binary extends AbstractStructArrayBase
{
    /**
     * The base64Binary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $base64Binary;
    /**
     * Constructor method for ArrayOfBase64Binary
     * @uses ArrayOfBase64Binary::setBase64Binary()
     * @param string[] $base64Binary
     */
    public function __construct(array $base64Binary = array())
    {
        $this
            ->setBase64Binary($base64Binary);
    }
    /**
     * Get base64Binary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getBase64Binary()
    {
        return isset($this->base64Binary) ? $this->base64Binary : null;
    }
    /**
     * Set base64Binary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $base64Binary
     * @return \ArrayType\ArrayOfBase64Binary
     */
    public function setBase64Binary(array $base64Binary = array())
    {
        foreach ($base64Binary as $arrayOfBase64BinaryBase64BinaryItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfBase64BinaryBase64BinaryItem)) {
                throw new \InvalidArgumentException(sprintf('The base64Binary property can only contain items of base64Binary, "%s" given', is_object($arrayOfBase64BinaryBase64BinaryItem) ? get_class($arrayOfBase64BinaryBase64BinaryItem) : gettype($arrayOfBase64BinaryBase64BinaryItem)), __LINE__);
            }
        }
        if (is_null($base64Binary) || (is_array($base64Binary) && empty($base64Binary))) {
            unset($this->base64Binary);
        } else {
            $this->base64Binary = $base64Binary;
        }
        return $this;
    }
    /**
     * Add item to base64Binary value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfBase64Binary
     */
    public function addToBase64Binary($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The base64Binary property can only contain items of base64Binary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->base64Binary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string base64Binary
     */
    public function getAttributeName()
    {
        return 'base64Binary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBase64Binary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
