<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ConsultaEstadoCotizacion
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaEstadoCotizacionRequest $parameters
     * @return \StructType\ConsultaEstadoCotizacionResponse|bool
     */
    public function ConsultaEstadoCotizacion(\StructType\ConsultaEstadoCotizacionRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaEstadoCotizacion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaSiniestralidad
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaSiniestralidadRequest $parameters
     * @return \StructType\ConsultaSiniestralidadResponse|bool
     */
    public function ConsultaSiniestralidad(\StructType\ConsultaSiniestralidadRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaSiniestralidad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPlanPago
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaPlanPagoRequest $parameters
     * @return \StructType\ConsultaPlanPagoResponse|bool
     */
    public function ConsultaPlanPago(\StructType\ConsultaPlanPagoRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaPlanPago($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaContactabilidad
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaContactabilidadRequest $parameters
     * @return \StructType\ConsultaContactabilidadResponse|bool
     */
    public function ConsultaContactabilidad(\StructType\ConsultaContactabilidadRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaContactabilidad($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaDocumentos
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaDocumentosRequest $parameters
     * @return \StructType\ConsultaDocumentosResponse|bool
     */
    public function ConsultaDocumentos(\StructType\ConsultaDocumentosRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaDocumentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPolizaIndividual
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaPolizaIndividual $parameters
     * @return \StructType\ConsultaPolizaIndividualResponse|bool
     */
    public function ConsultaPolizaIndividual(\StructType\ConsultaPolizaIndividual $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaPolizaIndividual($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultaContactabilidadResponse|\StructType\ConsultaDocumentosResponse|\StructType\ConsultaEstadoCotizacionResponse|\StructType\ConsultaPlanPagoResponse|\StructType\ConsultaPolizaIndividualResponse|\StructType\ConsultaSiniestralidadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
