<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeducibleBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeducibleBase
 * @subpackage Structs
 */
class DeducibleBase extends AbstractStructBase
{
    /**
     * The Opcionales
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfOpcional
     */
    public $Opcionales;
    /**
     * The codigoDeducible
     * @var int
     */
    public $codigoDeducible;
    /**
     * The deducible
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deducible;
    /**
     * The nombrePlan
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nombrePlan;
    /**
     * The valorEnPeso
     * @var int
     */
    public $valorEnPeso;
    /**
     * The valorEnUf
     * @var float
     */
    public $valorEnUf;
    /**
     * The valorUf
     * @var float
     */
    public $valorUf;
    /**
     * Constructor method for DeducibleBase
     * @uses DeducibleBase::setOpcionales()
     * @uses DeducibleBase::setCodigoDeducible()
     * @uses DeducibleBase::setDeducible()
     * @uses DeducibleBase::setNombrePlan()
     * @uses DeducibleBase::setValorEnPeso()
     * @uses DeducibleBase::setValorEnUf()
     * @uses DeducibleBase::setValorUf()
     * @param \ArrayType\ArrayOfOpcional $opcionales
     * @param int $codigoDeducible
     * @param string $deducible
     * @param string $nombrePlan
     * @param int $valorEnPeso
     * @param float $valorEnUf
     * @param float $valorUf
     */
    public function __construct(\ArrayType\ArrayOfOpcional $opcionales = null, $codigoDeducible = null, $deducible = null, $nombrePlan = null, $valorEnPeso = null, $valorEnUf = null, $valorUf = null)
    {
        $this
            ->setOpcionales($opcionales)
            ->setCodigoDeducible($codigoDeducible)
            ->setDeducible($deducible)
            ->setNombrePlan($nombrePlan)
            ->setValorEnPeso($valorEnPeso)
            ->setValorEnUf($valorEnUf)
            ->setValorUf($valorUf);
    }
    /**
     * Get Opcionales value
     * @return \ArrayType\ArrayOfOpcional|null
     */
    public function getOpcionales()
    {
        return $this->Opcionales;
    }
    /**
     * Set Opcionales value
     * @param \ArrayType\ArrayOfOpcional $opcionales
     * @return \StructType\DeducibleBase
     */
    public function setOpcionales(\ArrayType\ArrayOfOpcional $opcionales = null)
    {
        $this->Opcionales = $opcionales;
        return $this;
    }
    /**
     * Get codigoDeducible value
     * @return int|null
     */
    public function getCodigoDeducible()
    {
        return $this->codigoDeducible;
    }
    /**
     * Set codigoDeducible value
     * @param int $codigoDeducible
     * @return \StructType\DeducibleBase
     */
    public function setCodigoDeducible($codigoDeducible = null)
    {
        // validation for constraint: int
        if (!is_null($codigoDeducible) && !(is_int($codigoDeducible) || ctype_digit($codigoDeducible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoDeducible, true), gettype($codigoDeducible)), __LINE__);
        }
        $this->codigoDeducible = $codigoDeducible;
        return $this;
    }
    /**
     * Get deducible value
     * @return string|null
     */
    public function getDeducible()
    {
        return $this->deducible;
    }
    /**
     * Set deducible value
     * @param string $deducible
     * @return \StructType\DeducibleBase
     */
    public function setDeducible($deducible = null)
    {
        // validation for constraint: string
        if (!is_null($deducible) && !is_string($deducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deducible, true), gettype($deducible)), __LINE__);
        }
        $this->deducible = $deducible;
        return $this;
    }
    /**
     * Get nombrePlan value
     * @return string|null
     */
    public function getNombrePlan()
    {
        return $this->nombrePlan;
    }
    /**
     * Set nombrePlan value
     * @param string $nombrePlan
     * @return \StructType\DeducibleBase
     */
    public function setNombrePlan($nombrePlan = null)
    {
        // validation for constraint: string
        if (!is_null($nombrePlan) && !is_string($nombrePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombrePlan, true), gettype($nombrePlan)), __LINE__);
        }
        $this->nombrePlan = $nombrePlan;
        return $this;
    }
    /**
     * Get valorEnPeso value
     * @return int|null
     */
    public function getValorEnPeso()
    {
        return $this->valorEnPeso;
    }
    /**
     * Set valorEnPeso value
     * @param int $valorEnPeso
     * @return \StructType\DeducibleBase
     */
    public function setValorEnPeso($valorEnPeso = null)
    {
        // validation for constraint: int
        if (!is_null($valorEnPeso) && !(is_int($valorEnPeso) || ctype_digit($valorEnPeso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valorEnPeso, true), gettype($valorEnPeso)), __LINE__);
        }
        $this->valorEnPeso = $valorEnPeso;
        return $this;
    }
    /**
     * Get valorEnUf value
     * @return float|null
     */
    public function getValorEnUf()
    {
        return $this->valorEnUf;
    }
    /**
     * Set valorEnUf value
     * @param float $valorEnUf
     * @return \StructType\DeducibleBase
     */
    public function setValorEnUf($valorEnUf = null)
    {
        // validation for constraint: float
        if (!is_null($valorEnUf) && !(is_float($valorEnUf) || is_numeric($valorEnUf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorEnUf, true), gettype($valorEnUf)), __LINE__);
        }
        $this->valorEnUf = $valorEnUf;
        return $this;
    }
    /**
     * Get valorUf value
     * @return float|null
     */
    public function getValorUf()
    {
        return $this->valorUf;
    }
    /**
     * Set valorUf value
     * @param float $valorUf
     * @return \StructType\DeducibleBase
     */
    public function setValorUf($valorUf = null)
    {
        // validation for constraint: float
        if (!is_null($valorUf) && !(is_float($valorUf) || is_numeric($valorUf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorUf, true), gettype($valorUf)), __LINE__);
        }
        $this->valorUf = $valorUf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeducibleBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
