<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformacionSolicitudInspeccionModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InformacionSolicitudInspeccionModel
 * @subpackage Structs
 */
class InformacionSolicitudInspeccionModel extends AbstractStructBase
{
    /**
     * The Canal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Canal;
    /**
     * The Contacto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContactoPagoModel
     */
    public $Contacto;
    /**
     * The Estado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estado;
    /**
     * The FechaCoordinada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FechaCoordinada;
    /**
     * The FechaSolicitud
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FechaSolicitud;
    /**
     * The IdCiudad
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdCiudad;
    /**
     * The IdComuna
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdComuna;
    /**
     * The IdEstadoSolicitud
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdEstadoSolicitud;
    /**
     * The IdMarca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdMarca;
    /**
     * The IdModelo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdModelo;
    /**
     * The IdProveedor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdProveedor;
    /**
     * The IdRegion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdRegion;
    /**
     * The IdSucursal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdSucursal;
    /**
     * The InformacionPago
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InformacionPagoModel
     */
    public $InformacionPago;
    /**
     * The MateriaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MateriaId;
    /**
     * The MotivoInspeccion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MotivoInspeccion;
    /**
     * The NombreCorredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NombreCorredor;
    /**
     * The NumeroInspeccionProveedor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroInspeccionProveedor;
    /**
     * The Patente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Patente;
    /**
     * The Poliza
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Poliza;
    /**
     * The RutCorredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RutCorredor;
    /**
     * The RutInspector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RutInspector;
    /**
     * Constructor method for InformacionSolicitudInspeccionModel
     * @uses InformacionSolicitudInspeccionModel::setCanal()
     * @uses InformacionSolicitudInspeccionModel::setContacto()
     * @uses InformacionSolicitudInspeccionModel::setEstado()
     * @uses InformacionSolicitudInspeccionModel::setFechaCoordinada()
     * @uses InformacionSolicitudInspeccionModel::setFechaSolicitud()
     * @uses InformacionSolicitudInspeccionModel::setIdCiudad()
     * @uses InformacionSolicitudInspeccionModel::setIdComuna()
     * @uses InformacionSolicitudInspeccionModel::setIdEstadoSolicitud()
     * @uses InformacionSolicitudInspeccionModel::setIdMarca()
     * @uses InformacionSolicitudInspeccionModel::setIdModelo()
     * @uses InformacionSolicitudInspeccionModel::setIdProveedor()
     * @uses InformacionSolicitudInspeccionModel::setIdRegion()
     * @uses InformacionSolicitudInspeccionModel::setIdSucursal()
     * @uses InformacionSolicitudInspeccionModel::setInformacionPago()
     * @uses InformacionSolicitudInspeccionModel::setMateriaId()
     * @uses InformacionSolicitudInspeccionModel::setMotivoInspeccion()
     * @uses InformacionSolicitudInspeccionModel::setNombreCorredor()
     * @uses InformacionSolicitudInspeccionModel::setNumeroInspeccionProveedor()
     * @uses InformacionSolicitudInspeccionModel::setPatente()
     * @uses InformacionSolicitudInspeccionModel::setPoliza()
     * @uses InformacionSolicitudInspeccionModel::setRutCorredor()
     * @uses InformacionSolicitudInspeccionModel::setRutInspector()
     * @param int $canal
     * @param \StructType\ContactoPagoModel $contacto
     * @param string $estado
     * @param string $fechaCoordinada
     * @param string $fechaSolicitud
     * @param string $idCiudad
     * @param string $idComuna
     * @param int $idEstadoSolicitud
     * @param string $idMarca
     * @param int $idModelo
     * @param int $idProveedor
     * @param string $idRegion
     * @param string $idSucursal
     * @param \StructType\InformacionPagoModel $informacionPago
     * @param string $materiaId
     * @param string $motivoInspeccion
     * @param string $nombreCorredor
     * @param int $numeroInspeccionProveedor
     * @param string $patente
     * @param int $poliza
     * @param string $rutCorredor
     * @param string $rutInspector
     */
    public function __construct($canal = null, \StructType\ContactoPagoModel $contacto = null, $estado = null, $fechaCoordinada = null, $fechaSolicitud = null, $idCiudad = null, $idComuna = null, $idEstadoSolicitud = null, $idMarca = null, $idModelo = null, $idProveedor = null, $idRegion = null, $idSucursal = null, \StructType\InformacionPagoModel $informacionPago = null, $materiaId = null, $motivoInspeccion = null, $nombreCorredor = null, $numeroInspeccionProveedor = null, $patente = null, $poliza = null, $rutCorredor = null, $rutInspector = null)
    {
        $this
            ->setCanal($canal)
            ->setContacto($contacto)
            ->setEstado($estado)
            ->setFechaCoordinada($fechaCoordinada)
            ->setFechaSolicitud($fechaSolicitud)
            ->setIdCiudad($idCiudad)
            ->setIdComuna($idComuna)
            ->setIdEstadoSolicitud($idEstadoSolicitud)
            ->setIdMarca($idMarca)
            ->setIdModelo($idModelo)
            ->setIdProveedor($idProveedor)
            ->setIdRegion($idRegion)
            ->setIdSucursal($idSucursal)
            ->setInformacionPago($informacionPago)
            ->setMateriaId($materiaId)
            ->setMotivoInspeccion($motivoInspeccion)
            ->setNombreCorredor($nombreCorredor)
            ->setNumeroInspeccionProveedor($numeroInspeccionProveedor)
            ->setPatente($patente)
            ->setPoliza($poliza)
            ->setRutCorredor($rutCorredor)
            ->setRutInspector($rutInspector);
    }
    /**
     * Get Canal value
     * @return int|null
     */
    public function getCanal()
    {
        return $this->Canal;
    }
    /**
     * Set Canal value
     * @param int $canal
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setCanal($canal = null)
    {
        // validation for constraint: int
        if (!is_null($canal) && !(is_int($canal) || ctype_digit($canal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($canal, true), gettype($canal)), __LINE__);
        }
        $this->Canal = $canal;
        return $this;
    }
    /**
     * Get Contacto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContactoPagoModel|null
     */
    public function getContacto()
    {
        return isset($this->Contacto) ? $this->Contacto : null;
    }
    /**
     * Set Contacto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ContactoPagoModel $contacto
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setContacto(\StructType\ContactoPagoModel $contacto = null)
    {
        if (is_null($contacto) || (is_array($contacto) && empty($contacto))) {
            unset($this->Contacto);
        } else {
            $this->Contacto = $contacto;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estado
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estado, true), gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get FechaCoordinada value
     * @return string|null
     */
    public function getFechaCoordinada()
    {
        return $this->FechaCoordinada;
    }
    /**
     * Set FechaCoordinada value
     * @param string $fechaCoordinada
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setFechaCoordinada($fechaCoordinada = null)
    {
        // validation for constraint: string
        if (!is_null($fechaCoordinada) && !is_string($fechaCoordinada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaCoordinada, true), gettype($fechaCoordinada)), __LINE__);
        }
        $this->FechaCoordinada = $fechaCoordinada;
        return $this;
    }
    /**
     * Get FechaSolicitud value
     * @return string|null
     */
    public function getFechaSolicitud()
    {
        return $this->FechaSolicitud;
    }
    /**
     * Set FechaSolicitud value
     * @param string $fechaSolicitud
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setFechaSolicitud($fechaSolicitud = null)
    {
        // validation for constraint: string
        if (!is_null($fechaSolicitud) && !is_string($fechaSolicitud)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaSolicitud, true), gettype($fechaSolicitud)), __LINE__);
        }
        $this->FechaSolicitud = $fechaSolicitud;
        return $this;
    }
    /**
     * Get IdCiudad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdCiudad()
    {
        return isset($this->IdCiudad) ? $this->IdCiudad : null;
    }
    /**
     * Set IdCiudad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idCiudad
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdCiudad($idCiudad = null)
    {
        // validation for constraint: string
        if (!is_null($idCiudad) && !is_string($idCiudad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idCiudad, true), gettype($idCiudad)), __LINE__);
        }
        if (is_null($idCiudad) || (is_array($idCiudad) && empty($idCiudad))) {
            unset($this->IdCiudad);
        } else {
            $this->IdCiudad = $idCiudad;
        }
        return $this;
    }
    /**
     * Get IdComuna value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdComuna()
    {
        return isset($this->IdComuna) ? $this->IdComuna : null;
    }
    /**
     * Set IdComuna value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idComuna
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdComuna($idComuna = null)
    {
        // validation for constraint: string
        if (!is_null($idComuna) && !is_string($idComuna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idComuna, true), gettype($idComuna)), __LINE__);
        }
        if (is_null($idComuna) || (is_array($idComuna) && empty($idComuna))) {
            unset($this->IdComuna);
        } else {
            $this->IdComuna = $idComuna;
        }
        return $this;
    }
    /**
     * Get IdEstadoSolicitud value
     * @return int|null
     */
    public function getIdEstadoSolicitud()
    {
        return $this->IdEstadoSolicitud;
    }
    /**
     * Set IdEstadoSolicitud value
     * @param int $idEstadoSolicitud
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdEstadoSolicitud($idEstadoSolicitud = null)
    {
        // validation for constraint: int
        if (!is_null($idEstadoSolicitud) && !(is_int($idEstadoSolicitud) || ctype_digit($idEstadoSolicitud))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idEstadoSolicitud, true), gettype($idEstadoSolicitud)), __LINE__);
        }
        $this->IdEstadoSolicitud = $idEstadoSolicitud;
        return $this;
    }
    /**
     * Get IdMarca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdMarca()
    {
        return isset($this->IdMarca) ? $this->IdMarca : null;
    }
    /**
     * Set IdMarca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idMarca
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdMarca($idMarca = null)
    {
        // validation for constraint: string
        if (!is_null($idMarca) && !is_string($idMarca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idMarca, true), gettype($idMarca)), __LINE__);
        }
        if (is_null($idMarca) || (is_array($idMarca) && empty($idMarca))) {
            unset($this->IdMarca);
        } else {
            $this->IdMarca = $idMarca;
        }
        return $this;
    }
    /**
     * Get IdModelo value
     * @return int|null
     */
    public function getIdModelo()
    {
        return $this->IdModelo;
    }
    /**
     * Set IdModelo value
     * @param int $idModelo
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdModelo($idModelo = null)
    {
        // validation for constraint: int
        if (!is_null($idModelo) && !(is_int($idModelo) || ctype_digit($idModelo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idModelo, true), gettype($idModelo)), __LINE__);
        }
        $this->IdModelo = $idModelo;
        return $this;
    }
    /**
     * Get IdProveedor value
     * @return int|null
     */
    public function getIdProveedor()
    {
        return $this->IdProveedor;
    }
    /**
     * Set IdProveedor value
     * @param int $idProveedor
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdProveedor($idProveedor = null)
    {
        // validation for constraint: int
        if (!is_null($idProveedor) && !(is_int($idProveedor) || ctype_digit($idProveedor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idProveedor, true), gettype($idProveedor)), __LINE__);
        }
        $this->IdProveedor = $idProveedor;
        return $this;
    }
    /**
     * Get IdRegion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdRegion()
    {
        return isset($this->IdRegion) ? $this->IdRegion : null;
    }
    /**
     * Set IdRegion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idRegion
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdRegion($idRegion = null)
    {
        // validation for constraint: string
        if (!is_null($idRegion) && !is_string($idRegion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idRegion, true), gettype($idRegion)), __LINE__);
        }
        if (is_null($idRegion) || (is_array($idRegion) && empty($idRegion))) {
            unset($this->IdRegion);
        } else {
            $this->IdRegion = $idRegion;
        }
        return $this;
    }
    /**
     * Get IdSucursal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdSucursal()
    {
        return isset($this->IdSucursal) ? $this->IdSucursal : null;
    }
    /**
     * Set IdSucursal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idSucursal
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setIdSucursal($idSucursal = null)
    {
        // validation for constraint: string
        if (!is_null($idSucursal) && !is_string($idSucursal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idSucursal, true), gettype($idSucursal)), __LINE__);
        }
        if (is_null($idSucursal) || (is_array($idSucursal) && empty($idSucursal))) {
            unset($this->IdSucursal);
        } else {
            $this->IdSucursal = $idSucursal;
        }
        return $this;
    }
    /**
     * Get InformacionPago value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InformacionPagoModel|null
     */
    public function getInformacionPago()
    {
        return isset($this->InformacionPago) ? $this->InformacionPago : null;
    }
    /**
     * Set InformacionPago value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\InformacionPagoModel $informacionPago
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setInformacionPago(\StructType\InformacionPagoModel $informacionPago = null)
    {
        if (is_null($informacionPago) || (is_array($informacionPago) && empty($informacionPago))) {
            unset($this->InformacionPago);
        } else {
            $this->InformacionPago = $informacionPago;
        }
        return $this;
    }
    /**
     * Get MateriaId value
     * @return string|null
     */
    public function getMateriaId()
    {
        return $this->MateriaId;
    }
    /**
     * Set MateriaId value
     * @param string $materiaId
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setMateriaId($materiaId = null)
    {
        // validation for constraint: string
        if (!is_null($materiaId) && !is_string($materiaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materiaId, true), gettype($materiaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($materiaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $materiaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($materiaId, true)), __LINE__);
        }
        $this->MateriaId = $materiaId;
        return $this;
    }
    /**
     * Get MotivoInspeccion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoInspeccion()
    {
        return isset($this->MotivoInspeccion) ? $this->MotivoInspeccion : null;
    }
    /**
     * Set MotivoInspeccion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoInspeccion
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setMotivoInspeccion($motivoInspeccion = null)
    {
        // validation for constraint: string
        if (!is_null($motivoInspeccion) && !is_string($motivoInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoInspeccion, true), gettype($motivoInspeccion)), __LINE__);
        }
        if (is_null($motivoInspeccion) || (is_array($motivoInspeccion) && empty($motivoInspeccion))) {
            unset($this->MotivoInspeccion);
        } else {
            $this->MotivoInspeccion = $motivoInspeccion;
        }
        return $this;
    }
    /**
     * Get NombreCorredor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNombreCorredor()
    {
        return isset($this->NombreCorredor) ? $this->NombreCorredor : null;
    }
    /**
     * Set NombreCorredor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nombreCorredor
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setNombreCorredor($nombreCorredor = null)
    {
        // validation for constraint: string
        if (!is_null($nombreCorredor) && !is_string($nombreCorredor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreCorredor, true), gettype($nombreCorredor)), __LINE__);
        }
        if (is_null($nombreCorredor) || (is_array($nombreCorredor) && empty($nombreCorredor))) {
            unset($this->NombreCorredor);
        } else {
            $this->NombreCorredor = $nombreCorredor;
        }
        return $this;
    }
    /**
     * Get NumeroInspeccionProveedor value
     * @return int|null
     */
    public function getNumeroInspeccionProveedor()
    {
        return $this->NumeroInspeccionProveedor;
    }
    /**
     * Set NumeroInspeccionProveedor value
     * @param int $numeroInspeccionProveedor
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setNumeroInspeccionProveedor($numeroInspeccionProveedor = null)
    {
        // validation for constraint: int
        if (!is_null($numeroInspeccionProveedor) && !(is_int($numeroInspeccionProveedor) || ctype_digit($numeroInspeccionProveedor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroInspeccionProveedor, true), gettype($numeroInspeccionProveedor)), __LINE__);
        }
        $this->NumeroInspeccionProveedor = $numeroInspeccionProveedor;
        return $this;
    }
    /**
     * Get Patente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPatente()
    {
        return isset($this->Patente) ? $this->Patente : null;
    }
    /**
     * Set Patente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $patente
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setPatente($patente = null)
    {
        // validation for constraint: string
        if (!is_null($patente) && !is_string($patente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patente, true), gettype($patente)), __LINE__);
        }
        if (is_null($patente) || (is_array($patente) && empty($patente))) {
            unset($this->Patente);
        } else {
            $this->Patente = $patente;
        }
        return $this;
    }
    /**
     * Get Poliza value
     * @return int|null
     */
    public function getPoliza()
    {
        return $this->Poliza;
    }
    /**
     * Set Poliza value
     * @param int $poliza
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setPoliza($poliza = null)
    {
        // validation for constraint: int
        if (!is_null($poliza) && !(is_int($poliza) || ctype_digit($poliza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poliza, true), gettype($poliza)), __LINE__);
        }
        $this->Poliza = $poliza;
        return $this;
    }
    /**
     * Get RutCorredor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRutCorredor()
    {
        return isset($this->RutCorredor) ? $this->RutCorredor : null;
    }
    /**
     * Set RutCorredor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rutCorredor
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setRutCorredor($rutCorredor = null)
    {
        // validation for constraint: string
        if (!is_null($rutCorredor) && !is_string($rutCorredor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rutCorredor, true), gettype($rutCorredor)), __LINE__);
        }
        if (is_null($rutCorredor) || (is_array($rutCorredor) && empty($rutCorredor))) {
            unset($this->RutCorredor);
        } else {
            $this->RutCorredor = $rutCorredor;
        }
        return $this;
    }
    /**
     * Get RutInspector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRutInspector()
    {
        return isset($this->RutInspector) ? $this->RutInspector : null;
    }
    /**
     * Set RutInspector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rutInspector
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public function setRutInspector($rutInspector = null)
    {
        // validation for constraint: string
        if (!is_null($rutInspector) && !is_string($rutInspector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rutInspector, true), gettype($rutInspector)), __LINE__);
        }
        if (is_null($rutInspector) || (is_array($rutInspector) && empty($rutInspector))) {
            unset($this->RutInspector);
        } else {
            $this->RutInspector = $rutInspector;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InformacionSolicitudInspeccionModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
