<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfertaDescuentoModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OfertaDescuentoModel
 * @subpackage Structs
 */
class OfertaDescuentoModel extends AbstractStructBase
{
    /**
     * The CotizacionServicioID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CotizacionServicioID;
    /**
     * The RecargoDescuento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RecargoDescuento;
    /**
     * The ValorRecargo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorRecargo;
    /**
     * Constructor method for OfertaDescuentoModel
     * @uses OfertaDescuentoModel::setCotizacionServicioID()
     * @uses OfertaDescuentoModel::setRecargoDescuento()
     * @uses OfertaDescuentoModel::setValorRecargo()
     * @param string $cotizacionServicioID
     * @param string $recargoDescuento
     * @param float $valorRecargo
     */
    public function __construct($cotizacionServicioID = null, $recargoDescuento = null, $valorRecargo = null)
    {
        $this
            ->setCotizacionServicioID($cotizacionServicioID)
            ->setRecargoDescuento($recargoDescuento)
            ->setValorRecargo($valorRecargo);
    }
    /**
     * Get CotizacionServicioID value
     * @return string|null
     */
    public function getCotizacionServicioID()
    {
        return $this->CotizacionServicioID;
    }
    /**
     * Set CotizacionServicioID value
     * @param string $cotizacionServicioID
     * @return \StructType\OfertaDescuentoModel
     */
    public function setCotizacionServicioID($cotizacionServicioID = null)
    {
        // validation for constraint: string
        if (!is_null($cotizacionServicioID) && !is_string($cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotizacionServicioID, true), gettype($cotizacionServicioID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cotizacionServicioID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cotizacionServicioID, true)), __LINE__);
        }
        $this->CotizacionServicioID = $cotizacionServicioID;
        return $this;
    }
    /**
     * Get RecargoDescuento value
     * @return string|null
     */
    public function getRecargoDescuento()
    {
        return $this->RecargoDescuento;
    }
    /**
     * Set RecargoDescuento value
     * @uses \EnumType\RecargoDescuento::valueIsValid()
     * @uses \EnumType\RecargoDescuento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recargoDescuento
     * @return \StructType\OfertaDescuentoModel
     */
    public function setRecargoDescuento($recargoDescuento = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecargoDescuento::valueIsValid($recargoDescuento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RecargoDescuento', is_array($recargoDescuento) ? implode(', ', $recargoDescuento) : var_export($recargoDescuento, true), implode(', ', \EnumType\RecargoDescuento::getValidValues())), __LINE__);
        }
        $this->RecargoDescuento = $recargoDescuento;
        return $this;
    }
    /**
     * Get ValorRecargo value
     * @return float|null
     */
    public function getValorRecargo()
    {
        return $this->ValorRecargo;
    }
    /**
     * Set ValorRecargo value
     * @param float $valorRecargo
     * @return \StructType\OfertaDescuentoModel
     */
    public function setValorRecargo($valorRecargo = null)
    {
        // validation for constraint: float
        if (!is_null($valorRecargo) && !(is_float($valorRecargo) || is_numeric($valorRecargo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorRecargo, true), gettype($valorRecargo)), __LINE__);
        }
        $this->ValorRecargo = $valorRecargo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OfertaDescuentoModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
