<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanPagoModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PlanPagoModel
 * @subpackage Structs
 */
class PlanPagoModel extends AbstractStructBase
{
    /**
     * The Banco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Banco;
    /**
     * The Cuotas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPlanPagoCuotasModel
     */
    public $Cuotas;
    /**
     * The EstaPagada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EstaPagada;
    /**
     * The FormaPago
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormaPago;
    /**
     * The NumeroCuentaOTarjeta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroCuentaOTarjeta;
    /**
     * The NumeroCuotas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroCuotas;
    /**
     * The PrimeraCuota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimeraCuota;
    /**
     * The Tarjeta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tarjeta;
    /**
     * Constructor method for PlanPagoModel
     * @uses PlanPagoModel::setBanco()
     * @uses PlanPagoModel::setCuotas()
     * @uses PlanPagoModel::setEstaPagada()
     * @uses PlanPagoModel::setFormaPago()
     * @uses PlanPagoModel::setNumeroCuentaOTarjeta()
     * @uses PlanPagoModel::setNumeroCuotas()
     * @uses PlanPagoModel::setPrimeraCuota()
     * @uses PlanPagoModel::setTarjeta()
     * @param string $banco
     * @param \ArrayType\ArrayOfPlanPagoCuotasModel $cuotas
     * @param bool $estaPagada
     * @param string $formaPago
     * @param string $numeroCuentaOTarjeta
     * @param int $numeroCuotas
     * @param string $primeraCuota
     * @param string $tarjeta
     */
    public function __construct($banco = null, \ArrayType\ArrayOfPlanPagoCuotasModel $cuotas = null, $estaPagada = null, $formaPago = null, $numeroCuentaOTarjeta = null, $numeroCuotas = null, $primeraCuota = null, $tarjeta = null)
    {
        $this
            ->setBanco($banco)
            ->setCuotas($cuotas)
            ->setEstaPagada($estaPagada)
            ->setFormaPago($formaPago)
            ->setNumeroCuentaOTarjeta($numeroCuentaOTarjeta)
            ->setNumeroCuotas($numeroCuotas)
            ->setPrimeraCuota($primeraCuota)
            ->setTarjeta($tarjeta);
    }
    /**
     * Get Banco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBanco()
    {
        return isset($this->Banco) ? $this->Banco : null;
    }
    /**
     * Set Banco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $banco
     * @return \StructType\PlanPagoModel
     */
    public function setBanco($banco = null)
    {
        // validation for constraint: string
        if (!is_null($banco) && !is_string($banco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($banco, true), gettype($banco)), __LINE__);
        }
        if (is_null($banco) || (is_array($banco) && empty($banco))) {
            unset($this->Banco);
        } else {
            $this->Banco = $banco;
        }
        return $this;
    }
    /**
     * Get Cuotas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPlanPagoCuotasModel|null
     */
    public function getCuotas()
    {
        return isset($this->Cuotas) ? $this->Cuotas : null;
    }
    /**
     * Set Cuotas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPlanPagoCuotasModel $cuotas
     * @return \StructType\PlanPagoModel
     */
    public function setCuotas(\ArrayType\ArrayOfPlanPagoCuotasModel $cuotas = null)
    {
        if (is_null($cuotas) || (is_array($cuotas) && empty($cuotas))) {
            unset($this->Cuotas);
        } else {
            $this->Cuotas = $cuotas;
        }
        return $this;
    }
    /**
     * Get EstaPagada value
     * @return bool|null
     */
    public function getEstaPagada()
    {
        return $this->EstaPagada;
    }
    /**
     * Set EstaPagada value
     * @param bool $estaPagada
     * @return \StructType\PlanPagoModel
     */
    public function setEstaPagada($estaPagada = null)
    {
        // validation for constraint: boolean
        if (!is_null($estaPagada) && !is_bool($estaPagada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estaPagada, true), gettype($estaPagada)), __LINE__);
        }
        $this->EstaPagada = $estaPagada;
        return $this;
    }
    /**
     * Get FormaPago value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormaPago()
    {
        return isset($this->FormaPago) ? $this->FormaPago : null;
    }
    /**
     * Set FormaPago value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formaPago
     * @return \StructType\PlanPagoModel
     */
    public function setFormaPago($formaPago = null)
    {
        // validation for constraint: string
        if (!is_null($formaPago) && !is_string($formaPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formaPago, true), gettype($formaPago)), __LINE__);
        }
        if (is_null($formaPago) || (is_array($formaPago) && empty($formaPago))) {
            unset($this->FormaPago);
        } else {
            $this->FormaPago = $formaPago;
        }
        return $this;
    }
    /**
     * Get NumeroCuentaOTarjeta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroCuentaOTarjeta()
    {
        return isset($this->NumeroCuentaOTarjeta) ? $this->NumeroCuentaOTarjeta : null;
    }
    /**
     * Set NumeroCuentaOTarjeta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroCuentaOTarjeta
     * @return \StructType\PlanPagoModel
     */
    public function setNumeroCuentaOTarjeta($numeroCuentaOTarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($numeroCuentaOTarjeta) && !is_string($numeroCuentaOTarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroCuentaOTarjeta, true), gettype($numeroCuentaOTarjeta)), __LINE__);
        }
        if (is_null($numeroCuentaOTarjeta) || (is_array($numeroCuentaOTarjeta) && empty($numeroCuentaOTarjeta))) {
            unset($this->NumeroCuentaOTarjeta);
        } else {
            $this->NumeroCuentaOTarjeta = $numeroCuentaOTarjeta;
        }
        return $this;
    }
    /**
     * Get NumeroCuotas value
     * @return int|null
     */
    public function getNumeroCuotas()
    {
        return $this->NumeroCuotas;
    }
    /**
     * Set NumeroCuotas value
     * @param int $numeroCuotas
     * @return \StructType\PlanPagoModel
     */
    public function setNumeroCuotas($numeroCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCuotas) && !(is_int($numeroCuotas) || ctype_digit($numeroCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCuotas, true), gettype($numeroCuotas)), __LINE__);
        }
        $this->NumeroCuotas = $numeroCuotas;
        return $this;
    }
    /**
     * Get PrimeraCuota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimeraCuota()
    {
        return isset($this->PrimeraCuota) ? $this->PrimeraCuota : null;
    }
    /**
     * Set PrimeraCuota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primeraCuota
     * @return \StructType\PlanPagoModel
     */
    public function setPrimeraCuota($primeraCuota = null)
    {
        // validation for constraint: string
        if (!is_null($primeraCuota) && !is_string($primeraCuota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primeraCuota, true), gettype($primeraCuota)), __LINE__);
        }
        if (is_null($primeraCuota) || (is_array($primeraCuota) && empty($primeraCuota))) {
            unset($this->PrimeraCuota);
        } else {
            $this->PrimeraCuota = $primeraCuota;
        }
        return $this;
    }
    /**
     * Get Tarjeta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTarjeta()
    {
        return isset($this->Tarjeta) ? $this->Tarjeta : null;
    }
    /**
     * Set Tarjeta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tarjeta
     * @return \StructType\PlanPagoModel
     */
    public function setTarjeta($tarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($tarjeta) && !is_string($tarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarjeta, true), gettype($tarjeta)), __LINE__);
        }
        if (is_null($tarjeta) || (is_array($tarjeta) && empty($tarjeta))) {
            unset($this->Tarjeta);
        } else {
            $this->Tarjeta = $tarjeta;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanPagoModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
