<?php

namespace EnumType;

/**
 * This class stands for OpcionalTaller EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OpcionalTaller
 * @subpackage Enumerations
 */
class OpcionalTaller
{
    /**
     * Constant for value 'TallerdeMarca'
     * @return string 'TallerdeMarca'
     */
    const VALUE_TALLERDE_MARCA = 'TallerdeMarca';
    /**
     * Constant for value 'TallerGarantia'
     * @return string 'TallerGarantia'
     */
    const VALUE_TALLER_GARANTIA = 'TallerGarantia';
    /**
     * Constant for value 'SinOpcional'
     * @return string 'SinOpcional'
     */
    const VALUE_SIN_OPCIONAL = 'SinOpcional';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TALLERDE_MARCA
     * @uses self::VALUE_TALLER_GARANTIA
     * @uses self::VALUE_SIN_OPCIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TALLERDE_MARCA,
            self::VALUE_TALLER_GARANTIA,
            self::VALUE_SIN_OPCIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
