<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolizaExternaPlanPagoModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PolizaExternaPlanPagoModel
 * @subpackage Structs
 */
class PolizaExternaPlanPagoModel extends AbstractStructBase
{
    /**
     * The PAC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PolizaExternaPlanPagoPACModel
     */
    public $PAC;
    /**
     * The PAT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PolizaExternaPlanPagoPATModel
     */
    public $PAT;
    /**
     * The diaVencimiento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $diaVencimiento;
    /**
     * The formaPago
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormaPago
     */
    public $formaPago;
    /**
     * The numeroCuotas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroCuotas;
    /**
     * Constructor method for PolizaExternaPlanPagoModel
     * @uses PolizaExternaPlanPagoModel::setPAC()
     * @uses PolizaExternaPlanPagoModel::setPAT()
     * @uses PolizaExternaPlanPagoModel::setDiaVencimiento()
     * @uses PolizaExternaPlanPagoModel::setFormaPago()
     * @uses PolizaExternaPlanPagoModel::setNumeroCuotas()
     * @param \StructType\PolizaExternaPlanPagoPACModel $pAC
     * @param \StructType\PolizaExternaPlanPagoPATModel $pAT
     * @param string $diaVencimiento
     * @param \StructType\FormaPago $formaPago
     * @param int $numeroCuotas
     */
    public function __construct(\StructType\PolizaExternaPlanPagoPACModel $pAC = null, \StructType\PolizaExternaPlanPagoPATModel $pAT = null, $diaVencimiento = null, \StructType\FormaPago $formaPago = null, $numeroCuotas = null)
    {
        $this
            ->setPAC($pAC)
            ->setPAT($pAT)
            ->setDiaVencimiento($diaVencimiento)
            ->setFormaPago($formaPago)
            ->setNumeroCuotas($numeroCuotas);
    }
    /**
     * Get PAC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PolizaExternaPlanPagoPACModel|null
     */
    public function getPAC()
    {
        return isset($this->PAC) ? $this->PAC : null;
    }
    /**
     * Set PAC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PolizaExternaPlanPagoPACModel $pAC
     * @return \StructType\PolizaExternaPlanPagoModel
     */
    public function setPAC(\StructType\PolizaExternaPlanPagoPACModel $pAC = null)
    {
        if (is_null($pAC) || (is_array($pAC) && empty($pAC))) {
            unset($this->PAC);
        } else {
            $this->PAC = $pAC;
        }
        return $this;
    }
    /**
     * Get PAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PolizaExternaPlanPagoPATModel|null
     */
    public function getPAT()
    {
        return isset($this->PAT) ? $this->PAT : null;
    }
    /**
     * Set PAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PolizaExternaPlanPagoPATModel $pAT
     * @return \StructType\PolizaExternaPlanPagoModel
     */
    public function setPAT(\StructType\PolizaExternaPlanPagoPATModel $pAT = null)
    {
        if (is_null($pAT) || (is_array($pAT) && empty($pAT))) {
            unset($this->PAT);
        } else {
            $this->PAT = $pAT;
        }
        return $this;
    }
    /**
     * Get diaVencimiento value
     * @return string|null
     */
    public function getDiaVencimiento()
    {
        return $this->diaVencimiento;
    }
    /**
     * Set diaVencimiento value
     * @uses \EnumType\DiaPagos::valueIsValid()
     * @uses \EnumType\DiaPagos::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $diaVencimiento
     * @return \StructType\PolizaExternaPlanPagoModel
     */
    public function setDiaVencimiento($diaVencimiento = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DiaPagos::valueIsValid($diaVencimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DiaPagos', is_array($diaVencimiento) ? implode(', ', $diaVencimiento) : var_export($diaVencimiento, true), implode(', ', \EnumType\DiaPagos::getValidValues())), __LINE__);
        }
        $this->diaVencimiento = $diaVencimiento;
        return $this;
    }
    /**
     * Get formaPago value
     * @return \StructType\FormaPago|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @param \StructType\FormaPago $formaPago
     * @return \StructType\PolizaExternaPlanPagoModel
     */
    public function setFormaPago(\StructType\FormaPago $formaPago = null)
    {
        $this->formaPago = $formaPago;
        return $this;
    }
    /**
     * Get numeroCuotas value
     * @return int|null
     */
    public function getNumeroCuotas()
    {
        return $this->numeroCuotas;
    }
    /**
     * Set numeroCuotas value
     * @param int $numeroCuotas
     * @return \StructType\PolizaExternaPlanPagoModel
     */
    public function setNumeroCuotas($numeroCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCuotas) && !(is_int($numeroCuotas) || ctype_digit($numeroCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCuotas, true), gettype($numeroCuotas)), __LINE__);
        }
        $this->numeroCuotas = $numeroCuotas;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolizaExternaPlanPagoModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
