<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeducibleKilometro StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeducibleKilometro
 * @subpackage Structs
 */
class DeducibleKilometro extends AbstractStructBase
{
    /**
     * The codigoDeducible
     * @var int
     */
    public $codigoDeducible;
    /**
     * The deducible
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deducible;
    /**
     * The esPrimaMinima
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $esPrimaMinima;
    /**
     * The kilometrosMaximo
     * @var int
     */
    public $kilometrosMaximo;
    /**
     * The nombrePlan
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nombrePlan;
    /**
     * The plan
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $plan;
    /**
     * The primaAutoclick
     * @var float
     */
    public $primaAutoclick;
    /**
     * The primaEnPeso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $primaEnPeso;
    /**
     * The primaFija
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $primaFija;
    /**
     * The primaKilometro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $primaKilometro;
    /**
     * The primaMaxima
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $primaMaxima;
    /**
     * The valorUf
     * @var float
     */
    public $valorUf;
    /**
     * Constructor method for DeducibleKilometro
     * @uses DeducibleKilometro::setCodigoDeducible()
     * @uses DeducibleKilometro::setDeducible()
     * @uses DeducibleKilometro::setEsPrimaMinima()
     * @uses DeducibleKilometro::setKilometrosMaximo()
     * @uses DeducibleKilometro::setNombrePlan()
     * @uses DeducibleKilometro::setPlan()
     * @uses DeducibleKilometro::setPrimaAutoclick()
     * @uses DeducibleKilometro::setPrimaEnPeso()
     * @uses DeducibleKilometro::setPrimaFija()
     * @uses DeducibleKilometro::setPrimaKilometro()
     * @uses DeducibleKilometro::setPrimaMaxima()
     * @uses DeducibleKilometro::setValorUf()
     * @param int $codigoDeducible
     * @param string $deducible
     * @param bool $esPrimaMinima
     * @param int $kilometrosMaximo
     * @param string $nombrePlan
     * @param string $plan
     * @param float $primaAutoclick
     * @param int $primaEnPeso
     * @param float $primaFija
     * @param float $primaKilometro
     * @param float $primaMaxima
     * @param float $valorUf
     */
    public function __construct($codigoDeducible = null, $deducible = null, $esPrimaMinima = null, $kilometrosMaximo = null, $nombrePlan = null, $plan = null, $primaAutoclick = null, $primaEnPeso = null, $primaFija = null, $primaKilometro = null, $primaMaxima = null, $valorUf = null)
    {
        $this
            ->setCodigoDeducible($codigoDeducible)
            ->setDeducible($deducible)
            ->setEsPrimaMinima($esPrimaMinima)
            ->setKilometrosMaximo($kilometrosMaximo)
            ->setNombrePlan($nombrePlan)
            ->setPlan($plan)
            ->setPrimaAutoclick($primaAutoclick)
            ->setPrimaEnPeso($primaEnPeso)
            ->setPrimaFija($primaFija)
            ->setPrimaKilometro($primaKilometro)
            ->setPrimaMaxima($primaMaxima)
            ->setValorUf($valorUf);
    }
    /**
     * Get codigoDeducible value
     * @return int|null
     */
    public function getCodigoDeducible()
    {
        return $this->codigoDeducible;
    }
    /**
     * Set codigoDeducible value
     * @param int $codigoDeducible
     * @return \StructType\DeducibleKilometro
     */
    public function setCodigoDeducible($codigoDeducible = null)
    {
        // validation for constraint: int
        if (!is_null($codigoDeducible) && !(is_int($codigoDeducible) || ctype_digit($codigoDeducible))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoDeducible, true), gettype($codigoDeducible)), __LINE__);
        }
        $this->codigoDeducible = $codigoDeducible;
        return $this;
    }
    /**
     * Get deducible value
     * @return string|null
     */
    public function getDeducible()
    {
        return $this->deducible;
    }
    /**
     * Set deducible value
     * @param string $deducible
     * @return \StructType\DeducibleKilometro
     */
    public function setDeducible($deducible = null)
    {
        // validation for constraint: string
        if (!is_null($deducible) && !is_string($deducible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deducible, true), gettype($deducible)), __LINE__);
        }
        $this->deducible = $deducible;
        return $this;
    }
    /**
     * Get esPrimaMinima value
     * @return bool|null
     */
    public function getEsPrimaMinima()
    {
        return $this->esPrimaMinima;
    }
    /**
     * Set esPrimaMinima value
     * @param bool $esPrimaMinima
     * @return \StructType\DeducibleKilometro
     */
    public function setEsPrimaMinima($esPrimaMinima = null)
    {
        // validation for constraint: boolean
        if (!is_null($esPrimaMinima) && !is_bool($esPrimaMinima)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esPrimaMinima, true), gettype($esPrimaMinima)), __LINE__);
        }
        $this->esPrimaMinima = $esPrimaMinima;
        return $this;
    }
    /**
     * Get kilometrosMaximo value
     * @return int|null
     */
    public function getKilometrosMaximo()
    {
        return $this->kilometrosMaximo;
    }
    /**
     * Set kilometrosMaximo value
     * @param int $kilometrosMaximo
     * @return \StructType\DeducibleKilometro
     */
    public function setKilometrosMaximo($kilometrosMaximo = null)
    {
        // validation for constraint: int
        if (!is_null($kilometrosMaximo) && !(is_int($kilometrosMaximo) || ctype_digit($kilometrosMaximo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kilometrosMaximo, true), gettype($kilometrosMaximo)), __LINE__);
        }
        $this->kilometrosMaximo = $kilometrosMaximo;
        return $this;
    }
    /**
     * Get nombrePlan value
     * @return string|null
     */
    public function getNombrePlan()
    {
        return $this->nombrePlan;
    }
    /**
     * Set nombrePlan value
     * @param string $nombrePlan
     * @return \StructType\DeducibleKilometro
     */
    public function setNombrePlan($nombrePlan = null)
    {
        // validation for constraint: string
        if (!is_null($nombrePlan) && !is_string($nombrePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombrePlan, true), gettype($nombrePlan)), __LINE__);
        }
        $this->nombrePlan = $nombrePlan;
        return $this;
    }
    /**
     * Get plan value
     * @return string|null
     */
    public function getPlan()
    {
        return $this->plan;
    }
    /**
     * Set plan value
     * @param string $plan
     * @return \StructType\DeducibleKilometro
     */
    public function setPlan($plan = null)
    {
        // validation for constraint: string
        if (!is_null($plan) && !is_string($plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plan, true), gettype($plan)), __LINE__);
        }
        $this->plan = $plan;
        return $this;
    }
    /**
     * Get primaAutoclick value
     * @return float|null
     */
    public function getPrimaAutoclick()
    {
        return $this->primaAutoclick;
    }
    /**
     * Set primaAutoclick value
     * @param float $primaAutoclick
     * @return \StructType\DeducibleKilometro
     */
    public function setPrimaAutoclick($primaAutoclick = null)
    {
        // validation for constraint: float
        if (!is_null($primaAutoclick) && !(is_float($primaAutoclick) || is_numeric($primaAutoclick))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primaAutoclick, true), gettype($primaAutoclick)), __LINE__);
        }
        $this->primaAutoclick = $primaAutoclick;
        return $this;
    }
    /**
     * Get primaEnPeso value
     * @return int|null
     */
    public function getPrimaEnPeso()
    {
        return $this->primaEnPeso;
    }
    /**
     * Set primaEnPeso value
     * @param int $primaEnPeso
     * @return \StructType\DeducibleKilometro
     */
    public function setPrimaEnPeso($primaEnPeso = null)
    {
        // validation for constraint: int
        if (!is_null($primaEnPeso) && !(is_int($primaEnPeso) || ctype_digit($primaEnPeso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($primaEnPeso, true), gettype($primaEnPeso)), __LINE__);
        }
        $this->primaEnPeso = $primaEnPeso;
        return $this;
    }
    /**
     * Get primaFija value
     * @return float|null
     */
    public function getPrimaFija()
    {
        return $this->primaFija;
    }
    /**
     * Set primaFija value
     * @param float $primaFija
     * @return \StructType\DeducibleKilometro
     */
    public function setPrimaFija($primaFija = null)
    {
        // validation for constraint: float
        if (!is_null($primaFija) && !(is_float($primaFija) || is_numeric($primaFija))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primaFija, true), gettype($primaFija)), __LINE__);
        }
        $this->primaFija = $primaFija;
        return $this;
    }
    /**
     * Get primaKilometro value
     * @return float|null
     */
    public function getPrimaKilometro()
    {
        return $this->primaKilometro;
    }
    /**
     * Set primaKilometro value
     * @param float $primaKilometro
     * @return \StructType\DeducibleKilometro
     */
    public function setPrimaKilometro($primaKilometro = null)
    {
        // validation for constraint: float
        if (!is_null($primaKilometro) && !(is_float($primaKilometro) || is_numeric($primaKilometro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primaKilometro, true), gettype($primaKilometro)), __LINE__);
        }
        $this->primaKilometro = $primaKilometro;
        return $this;
    }
    /**
     * Get primaMaxima value
     * @return float|null
     */
    public function getPrimaMaxima()
    {
        return $this->primaMaxima;
    }
    /**
     * Set primaMaxima value
     * @param float $primaMaxima
     * @return \StructType\DeducibleKilometro
     */
    public function setPrimaMaxima($primaMaxima = null)
    {
        // validation for constraint: float
        if (!is_null($primaMaxima) && !(is_float($primaMaxima) || is_numeric($primaMaxima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primaMaxima, true), gettype($primaMaxima)), __LINE__);
        }
        $this->primaMaxima = $primaMaxima;
        return $this;
    }
    /**
     * Get valorUf value
     * @return float|null
     */
    public function getValorUf()
    {
        return $this->valorUf;
    }
    /**
     * Set valorUf value
     * @param float $valorUf
     * @return \StructType\DeducibleKilometro
     */
    public function setValorUf($valorUf = null)
    {
        // validation for constraint: float
        if (!is_null($valorUf) && !(is_float($valorUf) || is_numeric($valorUf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorUf, true), gettype($valorUf)), __LINE__);
        }
        $this->valorUf = $valorUf;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeducibleKilometro
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
