<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultadoPolizaModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultadoPolizaModel
 * @subpackage Structs
 */
class ResultadoPolizaModel extends AbstractStructBase
{
    /**
     * The cantidadCuotas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cantidadCuotas;
    /**
     * The cotizacionServicioID
     * Meta informations extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $cotizacionServicioID;
    /**
     * The formaPago
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormaPago
     */
    public $formaPago;
    /**
     * The inicioVigencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inicioVigencia;
    /**
     * The iva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $iva;
    /**
     * The nombrePlan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nombrePlan;
    /**
     * The numeroPoliza
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numeroPoliza;
    /**
     * The polizaID
     * Meta informations extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $polizaID;
    /**
     * The polizaPdf
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $polizaPdf;
    /**
     * The primaAfecta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $primaAfecta;
    /**
     * The primaBruta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $primaBruta;
    /**
     * The primaExenta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $primaExenta;
    /**
     * The terminoVigencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $terminoVigencia;
    /**
     * Constructor method for ResultadoPolizaModel
     * @uses ResultadoPolizaModel::setCantidadCuotas()
     * @uses ResultadoPolizaModel::setCotizacionServicioID()
     * @uses ResultadoPolizaModel::setFormaPago()
     * @uses ResultadoPolizaModel::setInicioVigencia()
     * @uses ResultadoPolizaModel::setIva()
     * @uses ResultadoPolizaModel::setNombrePlan()
     * @uses ResultadoPolizaModel::setNumeroPoliza()
     * @uses ResultadoPolizaModel::setPolizaID()
     * @uses ResultadoPolizaModel::setPolizaPdf()
     * @uses ResultadoPolizaModel::setPrimaAfecta()
     * @uses ResultadoPolizaModel::setPrimaBruta()
     * @uses ResultadoPolizaModel::setPrimaExenta()
     * @uses ResultadoPolizaModel::setTerminoVigencia()
     * @param int $cantidadCuotas
     * @param string $cotizacionServicioID
     * @param \StructType\FormaPago $formaPago
     * @param string $inicioVigencia
     * @param float $iva
     * @param string $nombrePlan
     * @param string $numeroPoliza
     * @param string $polizaID
     * @param string $polizaPdf
     * @param float $primaAfecta
     * @param float $primaBruta
     * @param float $primaExenta
     * @param string $terminoVigencia
     */
    public function __construct($cantidadCuotas = null, $cotizacionServicioID = null, \StructType\FormaPago $formaPago = null, $inicioVigencia = null, $iva = null, $nombrePlan = null, $numeroPoliza = null, $polizaID = null, $polizaPdf = null, $primaAfecta = null, $primaBruta = null, $primaExenta = null, $terminoVigencia = null)
    {
        $this
            ->setCantidadCuotas($cantidadCuotas)
            ->setCotizacionServicioID($cotizacionServicioID)
            ->setFormaPago($formaPago)
            ->setInicioVigencia($inicioVigencia)
            ->setIva($iva)
            ->setNombrePlan($nombrePlan)
            ->setNumeroPoliza($numeroPoliza)
            ->setPolizaID($polizaID)
            ->setPolizaPdf($polizaPdf)
            ->setPrimaAfecta($primaAfecta)
            ->setPrimaBruta($primaBruta)
            ->setPrimaExenta($primaExenta)
            ->setTerminoVigencia($terminoVigencia);
    }
    /**
     * Get cantidadCuotas value
     * @return int|null
     */
    public function getCantidadCuotas()
    {
        return $this->cantidadCuotas;
    }
    /**
     * Set cantidadCuotas value
     * @param int $cantidadCuotas
     * @return \StructType\ResultadoPolizaModel
     */
    public function setCantidadCuotas($cantidadCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadCuotas) && !(is_int($cantidadCuotas) || ctype_digit($cantidadCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadCuotas, true), gettype($cantidadCuotas)), __LINE__);
        }
        $this->cantidadCuotas = $cantidadCuotas;
        return $this;
    }
    /**
     * Get cotizacionServicioID value
     * @return string|null
     */
    public function getCotizacionServicioID()
    {
        return $this->cotizacionServicioID;
    }
    /**
     * Set cotizacionServicioID value
     * @param string $cotizacionServicioID
     * @return \StructType\ResultadoPolizaModel
     */
    public function setCotizacionServicioID($cotizacionServicioID = null)
    {
        // validation for constraint: string
        if (!is_null($cotizacionServicioID) && !is_string($cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cotizacionServicioID, true), gettype($cotizacionServicioID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cotizacionServicioID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cotizacionServicioID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cotizacionServicioID, true)), __LINE__);
        }
        $this->cotizacionServicioID = $cotizacionServicioID;
        return $this;
    }
    /**
     * Get formaPago value
     * @return \StructType\FormaPago|null
     */
    public function getFormaPago()
    {
        return $this->formaPago;
    }
    /**
     * Set formaPago value
     * @param \StructType\FormaPago $formaPago
     * @return \StructType\ResultadoPolizaModel
     */
    public function setFormaPago(\StructType\FormaPago $formaPago = null)
    {
        $this->formaPago = $formaPago;
        return $this;
    }
    /**
     * Get inicioVigencia value
     * @return string|null
     */
    public function getInicioVigencia()
    {
        return $this->inicioVigencia;
    }
    /**
     * Set inicioVigencia value
     * @param string $inicioVigencia
     * @return \StructType\ResultadoPolizaModel
     */
    public function setInicioVigencia($inicioVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($inicioVigencia) && !is_string($inicioVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inicioVigencia, true), gettype($inicioVigencia)), __LINE__);
        }
        $this->inicioVigencia = $inicioVigencia;
        return $this;
    }
    /**
     * Get iva value
     * @return float|null
     */
    public function getIva()
    {
        return $this->iva;
    }
    /**
     * Set iva value
     * @param float $iva
     * @return \StructType\ResultadoPolizaModel
     */
    public function setIva($iva = null)
    {
        // validation for constraint: float
        if (!is_null($iva) && !(is_float($iva) || is_numeric($iva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iva, true), gettype($iva)), __LINE__);
        }
        $this->iva = $iva;
        return $this;
    }
    /**
     * Get nombrePlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNombrePlan()
    {
        return isset($this->nombrePlan) ? $this->nombrePlan : null;
    }
    /**
     * Set nombrePlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nombrePlan
     * @return \StructType\ResultadoPolizaModel
     */
    public function setNombrePlan($nombrePlan = null)
    {
        // validation for constraint: string
        if (!is_null($nombrePlan) && !is_string($nombrePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombrePlan, true), gettype($nombrePlan)), __LINE__);
        }
        if (is_null($nombrePlan) || (is_array($nombrePlan) && empty($nombrePlan))) {
            unset($this->nombrePlan);
        } else {
            $this->nombrePlan = $nombrePlan;
        }
        return $this;
    }
    /**
     * Get numeroPoliza value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroPoliza()
    {
        return isset($this->numeroPoliza) ? $this->numeroPoliza : null;
    }
    /**
     * Set numeroPoliza value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroPoliza
     * @return \StructType\ResultadoPolizaModel
     */
    public function setNumeroPoliza($numeroPoliza = null)
    {
        // validation for constraint: string
        if (!is_null($numeroPoliza) && !is_string($numeroPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroPoliza, true), gettype($numeroPoliza)), __LINE__);
        }
        if (is_null($numeroPoliza) || (is_array($numeroPoliza) && empty($numeroPoliza))) {
            unset($this->numeroPoliza);
        } else {
            $this->numeroPoliza = $numeroPoliza;
        }
        return $this;
    }
    /**
     * Get polizaID value
     * @return string|null
     */
    public function getPolizaID()
    {
        return $this->polizaID;
    }
    /**
     * Set polizaID value
     * @param string $polizaID
     * @return \StructType\ResultadoPolizaModel
     */
    public function setPolizaID($polizaID = null)
    {
        // validation for constraint: string
        if (!is_null($polizaID) && !is_string($polizaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polizaID, true), gettype($polizaID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($polizaID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $polizaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($polizaID, true)), __LINE__);
        }
        $this->polizaID = $polizaID;
        return $this;
    }
    /**
     * Get polizaPdf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolizaPdf()
    {
        return isset($this->polizaPdf) ? $this->polizaPdf : null;
    }
    /**
     * Set polizaPdf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $polizaPdf
     * @return \StructType\ResultadoPolizaModel
     */
    public function setPolizaPdf($polizaPdf = null)
    {
        // validation for constraint: string
        if (!is_null($polizaPdf) && !is_string($polizaPdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polizaPdf, true), gettype($polizaPdf)), __LINE__);
        }
        if (is_null($polizaPdf) || (is_array($polizaPdf) && empty($polizaPdf))) {
            unset($this->polizaPdf);
        } else {
            $this->polizaPdf = $polizaPdf;
        }
        return $this;
    }
    /**
     * Get primaAfecta value
     * @return float|null
     */
    public function getPrimaAfecta()
    {
        return $this->primaAfecta;
    }
    /**
     * Set primaAfecta value
     * @param float $primaAfecta
     * @return \StructType\ResultadoPolizaModel
     */
    public function setPrimaAfecta($primaAfecta = null)
    {
        // validation for constraint: float
        if (!is_null($primaAfecta) && !(is_float($primaAfecta) || is_numeric($primaAfecta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primaAfecta, true), gettype($primaAfecta)), __LINE__);
        }
        $this->primaAfecta = $primaAfecta;
        return $this;
    }
    /**
     * Get primaBruta value
     * @return float|null
     */
    public function getPrimaBruta()
    {
        return $this->primaBruta;
    }
    /**
     * Set primaBruta value
     * @param float $primaBruta
     * @return \StructType\ResultadoPolizaModel
     */
    public function setPrimaBruta($primaBruta = null)
    {
        // validation for constraint: float
        if (!is_null($primaBruta) && !(is_float($primaBruta) || is_numeric($primaBruta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primaBruta, true), gettype($primaBruta)), __LINE__);
        }
        $this->primaBruta = $primaBruta;
        return $this;
    }
    /**
     * Get primaExenta value
     * @return float|null
     */
    public function getPrimaExenta()
    {
        return $this->primaExenta;
    }
    /**
     * Set primaExenta value
     * @param float $primaExenta
     * @return \StructType\ResultadoPolizaModel
     */
    public function setPrimaExenta($primaExenta = null)
    {
        // validation for constraint: float
        if (!is_null($primaExenta) && !(is_float($primaExenta) || is_numeric($primaExenta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($primaExenta, true), gettype($primaExenta)), __LINE__);
        }
        $this->primaExenta = $primaExenta;
        return $this;
    }
    /**
     * Get terminoVigencia value
     * @return string|null
     */
    public function getTerminoVigencia()
    {
        return $this->terminoVigencia;
    }
    /**
     * Set terminoVigencia value
     * @param string $terminoVigencia
     * @return \StructType\ResultadoPolizaModel
     */
    public function setTerminoVigencia($terminoVigencia = null)
    {
        // validation for constraint: string
        if (!is_null($terminoVigencia) && !is_string($terminoVigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminoVigencia, true), gettype($terminoVigencia)), __LINE__);
        }
        $this->terminoVigencia = $terminoVigencia;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResultadoPolizaModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
