<?php

namespace EnumType;

/**
 * This class stands for OpcionalRCExceso EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OpcionalRCExceso
 * @subpackage Enumerations
 */
class OpcionalRCExceso
{
    /**
     * Constant for value 'MilUF'
     * @return string 'MilUF'
     */
    const VALUE_MIL_UF = 'MilUF';
    /**
     * Constant for value 'DosMilUF'
     * @return string 'DosMilUF'
     */
    const VALUE_DOS_MIL_UF = 'DosMilUF';
    /**
     * Constant for value 'SinOpcional'
     * @return string 'SinOpcional'
     */
    const VALUE_SIN_OPCIONAL = 'SinOpcional';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MIL_UF
     * @uses self::VALUE_DOS_MIL_UF
     * @uses self::VALUE_SIN_OPCIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MIL_UF,
            self::VALUE_DOS_MIL_UF,
            self::VALUE_SIN_OPCIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
