<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeducibleBase ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDeducibleBase
 * @subpackage Arrays
 */
class ArrayOfDeducibleBase extends AbstractStructArrayBase
{
    /**
     * The DeducibleBase
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeducibleBase[]
     */
    public $DeducibleBase;
    /**
     * Constructor method for ArrayOfDeducibleBase
     * @uses ArrayOfDeducibleBase::setDeducibleBase()
     * @param \StructType\DeducibleBase[] $deducibleBase
     */
    public function __construct(array $deducibleBase = array())
    {
        $this
            ->setDeducibleBase($deducibleBase);
    }
    /**
     * Get DeducibleBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeducibleBase[]|null
     */
    public function getDeducibleBase()
    {
        return isset($this->DeducibleBase) ? $this->DeducibleBase : null;
    }
    /**
     * Set DeducibleBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeducibleBase[] $deducibleBase
     * @return \ArrayType\ArrayOfDeducibleBase
     */
    public function setDeducibleBase(array $deducibleBase = array())
    {
        foreach ($deducibleBase as $arrayOfDeducibleBaseDeducibleBaseItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeducibleBaseDeducibleBaseItem instanceof \StructType\DeducibleBase) {
                throw new \InvalidArgumentException(sprintf('The DeducibleBase property can only contain items of \StructType\DeducibleBase, "%s" given', is_object($arrayOfDeducibleBaseDeducibleBaseItem) ? get_class($arrayOfDeducibleBaseDeducibleBaseItem) : gettype($arrayOfDeducibleBaseDeducibleBaseItem)), __LINE__);
            }
        }
        if (is_null($deducibleBase) || (is_array($deducibleBase) && empty($deducibleBase))) {
            unset($this->DeducibleBase);
        } else {
            $this->DeducibleBase = $deducibleBase;
        }
        return $this;
    }
    /**
     * Add item to DeducibleBase value
     * @throws \InvalidArgumentException
     * @param \StructType\DeducibleBase $item
     * @return \ArrayType\ArrayOfDeducibleBase
     */
    public function addToDeducibleBase(\StructType\DeducibleBase $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeducibleBase) {
            throw new \InvalidArgumentException(sprintf('The DeducibleBase property can only contain items of \StructType\DeducibleBase, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeducibleBase[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeducibleBase|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeducibleBase|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeducibleBase|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeducibleBase|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeducibleBase|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeducibleBase
     */
    public function getAttributeName()
    {
        return 'DeducibleBase';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDeducibleBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
