<?php

namespace EnumType;

/**
 * This class stands for UsoBienEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:UsoBienEnum
 * @subpackage Enumerations
 */
class UsoBienEnum
{
    /**
     * Constant for value 'Comercial'
     * @return string 'Comercial'
     */
    const VALUE_COMERCIAL = 'Comercial';
    /**
     * Constant for value 'Particular'
     * @return string 'Particular'
     */
    const VALUE_PARTICULAR = 'Particular';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMERCIAL
     * @uses self::VALUE_PARTICULAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMERCIAL,
            self::VALUE_PARTICULAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
