<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOpcional ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOpcional
 * @subpackage Arrays
 */
class ArrayOfOpcional extends AbstractStructArrayBase
{
    /**
     * The Opcional
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Opcional[]
     */
    public $Opcional;
    /**
     * Constructor method for ArrayOfOpcional
     * @uses ArrayOfOpcional::setOpcional()
     * @param \StructType\Opcional[] $opcional
     */
    public function __construct(array $opcional = array())
    {
        $this
            ->setOpcional($opcional);
    }
    /**
     * Get Opcional value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Opcional[]|null
     */
    public function getOpcional()
    {
        return isset($this->Opcional) ? $this->Opcional : null;
    }
    /**
     * Set Opcional value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Opcional[] $opcional
     * @return \ArrayType\ArrayOfOpcional
     */
    public function setOpcional(array $opcional = array())
    {
        foreach ($opcional as $arrayOfOpcionalOpcionalItem) {
            // validation for constraint: itemType
            if (!$arrayOfOpcionalOpcionalItem instanceof \StructType\Opcional) {
                throw new \InvalidArgumentException(sprintf('The Opcional property can only contain items of \StructType\Opcional, "%s" given', is_object($arrayOfOpcionalOpcionalItem) ? get_class($arrayOfOpcionalOpcionalItem) : gettype($arrayOfOpcionalOpcionalItem)), __LINE__);
            }
        }
        if (is_null($opcional) || (is_array($opcional) && empty($opcional))) {
            unset($this->Opcional);
        } else {
            $this->Opcional = $opcional;
        }
        return $this;
    }
    /**
     * Add item to Opcional value
     * @throws \InvalidArgumentException
     * @param \StructType\Opcional $item
     * @return \ArrayType\ArrayOfOpcional
     */
    public function addToOpcional(\StructType\Opcional $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Opcional) {
            throw new \InvalidArgumentException(sprintf('The Opcional property can only contain items of \StructType\Opcional, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Opcional[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Opcional|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Opcional|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Opcional|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Opcional|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Opcional|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Opcional
     */
    public function getAttributeName()
    {
        return 'Opcional';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOpcional
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
