<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanPagoCuotasModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PlanPagoCuotasModel
 * @subpackage Structs
 */
class PlanPagoCuotasModel extends AbstractStructBase
{
    /**
     * The FechaCuota
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FechaCuota;
    /**
     * The NumeroCuota
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroCuota;
    /**
     * The ValorCuota
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorCuota;
    /**
     * Constructor method for PlanPagoCuotasModel
     * @uses PlanPagoCuotasModel::setFechaCuota()
     * @uses PlanPagoCuotasModel::setNumeroCuota()
     * @uses PlanPagoCuotasModel::setValorCuota()
     * @param string $fechaCuota
     * @param int $numeroCuota
     * @param float $valorCuota
     */
    public function __construct($fechaCuota = null, $numeroCuota = null, $valorCuota = null)
    {
        $this
            ->setFechaCuota($fechaCuota)
            ->setNumeroCuota($numeroCuota)
            ->setValorCuota($valorCuota);
    }
    /**
     * Get FechaCuota value
     * @return string|null
     */
    public function getFechaCuota()
    {
        return $this->FechaCuota;
    }
    /**
     * Set FechaCuota value
     * @param string $fechaCuota
     * @return \StructType\PlanPagoCuotasModel
     */
    public function setFechaCuota($fechaCuota = null)
    {
        // validation for constraint: string
        if (!is_null($fechaCuota) && !is_string($fechaCuota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fechaCuota)), __LINE__);
        }
        $this->FechaCuota = $fechaCuota;
        return $this;
    }
    /**
     * Get NumeroCuota value
     * @return int|null
     */
    public function getNumeroCuota()
    {
        return $this->NumeroCuota;
    }
    /**
     * Set NumeroCuota value
     * @param int $numeroCuota
     * @return \StructType\PlanPagoCuotasModel
     */
    public function setNumeroCuota($numeroCuota = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCuota) && !is_numeric($numeroCuota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroCuota)), __LINE__);
        }
        $this->NumeroCuota = $numeroCuota;
        return $this;
    }
    /**
     * Get ValorCuota value
     * @return float|null
     */
    public function getValorCuota()
    {
        return $this->ValorCuota;
    }
    /**
     * Set ValorCuota value
     * @param float $valorCuota
     * @return \StructType\PlanPagoCuotasModel
     */
    public function setValorCuota($valorCuota = null)
    {
        $this->ValorCuota = $valorCuota;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlanPagoCuotasModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
