<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opcional StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Opcional
 * @subpackage Structs
 */
class Opcional extends AbstractStructBase
{
    /**
     * The descripcion
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $descripcion;
    /**
     * The factor
     * @var float
     */
    public $factor;
    /**
     * Constructor method for Opcional
     * @uses Opcional::setDescripcion()
     * @uses Opcional::setFactor()
     * @param string $descripcion
     * @param float $factor
     */
    public function __construct($descripcion = null, $factor = null)
    {
        $this
            ->setDescripcion($descripcion)
            ->setFactor($factor);
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\Opcional
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Get factor value
     * @return float|null
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param float $factor
     * @return \StructType\Opcional
     */
    public function setFactor($factor = null)
    {
        $this->factor = $factor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Opcional
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
