<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolizaPersonaModel StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PolizaPersonaModel
 * @subpackage Structs
 */
class PolizaPersonaModel extends AbstractStructBase
{
    /**
     * The apellidoMaterno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $apellidoMaterno;
    /**
     * The apellidoPaterno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $apellidoPaterno;
    /**
     * The comunaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $comunaID;
    /**
     * The direccion
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $direccion;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The fonoContacto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fonoContacto;
    /**
     * The nombre
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nombre;
    /**
     * The nombreCompleto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nombreCompleto;
    /**
     * The rut
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rut;
    /**
     * The sexo
     * @var string
     */
    public $sexo;
    /**
     * The tipoPersona
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoPersona;
    /**
     * Constructor method for PolizaPersonaModel
     * @uses PolizaPersonaModel::setApellidoMaterno()
     * @uses PolizaPersonaModel::setApellidoPaterno()
     * @uses PolizaPersonaModel::setComunaID()
     * @uses PolizaPersonaModel::setDireccion()
     * @uses PolizaPersonaModel::setEmail()
     * @uses PolizaPersonaModel::setFonoContacto()
     * @uses PolizaPersonaModel::setNombre()
     * @uses PolizaPersonaModel::setNombreCompleto()
     * @uses PolizaPersonaModel::setRut()
     * @uses PolizaPersonaModel::setSexo()
     * @uses PolizaPersonaModel::setTipoPersona()
     * @param string $apellidoMaterno
     * @param string $apellidoPaterno
     * @param int $comunaID
     * @param string $direccion
     * @param string $email
     * @param string $fonoContacto
     * @param string $nombre
     * @param string $nombreCompleto
     * @param string $rut
     * @param string $sexo
     * @param string $tipoPersona
     */
    public function __construct($apellidoMaterno = null, $apellidoPaterno = null, $comunaID = null, $direccion = null, $email = null, $fonoContacto = null, $nombre = null, $nombreCompleto = null, $rut = null, $sexo = null, $tipoPersona = null)
    {
        $this
            ->setApellidoMaterno($apellidoMaterno)
            ->setApellidoPaterno($apellidoPaterno)
            ->setComunaID($comunaID)
            ->setDireccion($direccion)
            ->setEmail($email)
            ->setFonoContacto($fonoContacto)
            ->setNombre($nombre)
            ->setNombreCompleto($nombreCompleto)
            ->setRut($rut)
            ->setSexo($sexo)
            ->setTipoPersona($tipoPersona);
    }
    /**
     * Get apellidoMaterno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApellidoMaterno()
    {
        return isset($this->apellidoMaterno) ? $this->apellidoMaterno : null;
    }
    /**
     * Set apellidoMaterno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apellidoMaterno
     * @return \StructType\PolizaPersonaModel
     */
    public function setApellidoMaterno($apellidoMaterno = null)
    {
        // validation for constraint: string
        if (!is_null($apellidoMaterno) && !is_string($apellidoMaterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apellidoMaterno)), __LINE__);
        }
        if (is_null($apellidoMaterno) || (is_array($apellidoMaterno) && empty($apellidoMaterno))) {
            unset($this->apellidoMaterno);
        } else {
            $this->apellidoMaterno = $apellidoMaterno;
        }
        return $this;
    }
    /**
     * Get apellidoPaterno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApellidoPaterno()
    {
        return isset($this->apellidoPaterno) ? $this->apellidoPaterno : null;
    }
    /**
     * Set apellidoPaterno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apellidoPaterno
     * @return \StructType\PolizaPersonaModel
     */
    public function setApellidoPaterno($apellidoPaterno = null)
    {
        // validation for constraint: string
        if (!is_null($apellidoPaterno) && !is_string($apellidoPaterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apellidoPaterno)), __LINE__);
        }
        if (is_null($apellidoPaterno) || (is_array($apellidoPaterno) && empty($apellidoPaterno))) {
            unset($this->apellidoPaterno);
        } else {
            $this->apellidoPaterno = $apellidoPaterno;
        }
        return $this;
    }
    /**
     * Get comunaID value
     * @return int|null
     */
    public function getComunaID()
    {
        return $this->comunaID;
    }
    /**
     * Set comunaID value
     * @param int $comunaID
     * @return \StructType\PolizaPersonaModel
     */
    public function setComunaID($comunaID = null)
    {
        // validation for constraint: int
        if (!is_null($comunaID) && !is_numeric($comunaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($comunaID)), __LINE__);
        }
        $this->comunaID = $comunaID;
        return $this;
    }
    /**
     * Get direccion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDireccion()
    {
        return isset($this->direccion) ? $this->direccion : null;
    }
    /**
     * Set direccion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $direccion
     * @return \StructType\PolizaPersonaModel
     */
    public function setDireccion($direccion = null)
    {
        // validation for constraint: string
        if (!is_null($direccion) && !is_string($direccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direccion)), __LINE__);
        }
        if (is_null($direccion) || (is_array($direccion) && empty($direccion))) {
            unset($this->direccion);
        } else {
            $this->direccion = $direccion;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\PolizaPersonaModel
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get fonoContacto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFonoContacto()
    {
        return isset($this->fonoContacto) ? $this->fonoContacto : null;
    }
    /**
     * Set fonoContacto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fonoContacto
     * @return \StructType\PolizaPersonaModel
     */
    public function setFonoContacto($fonoContacto = null)
    {
        // validation for constraint: string
        if (!is_null($fonoContacto) && !is_string($fonoContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fonoContacto)), __LINE__);
        }
        if (is_null($fonoContacto) || (is_array($fonoContacto) && empty($fonoContacto))) {
            unset($this->fonoContacto);
        } else {
            $this->fonoContacto = $fonoContacto;
        }
        return $this;
    }
    /**
     * Get nombre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNombre()
    {
        return isset($this->nombre) ? $this->nombre : null;
    }
    /**
     * Set nombre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nombre
     * @return \StructType\PolizaPersonaModel
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombre)), __LINE__);
        }
        if (is_null($nombre) || (is_array($nombre) && empty($nombre))) {
            unset($this->nombre);
        } else {
            $this->nombre = $nombre;
        }
        return $this;
    }
    /**
     * Get nombreCompleto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNombreCompleto()
    {
        return isset($this->nombreCompleto) ? $this->nombreCompleto : null;
    }
    /**
     * Set nombreCompleto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nombreCompleto
     * @return \StructType\PolizaPersonaModel
     */
    public function setNombreCompleto($nombreCompleto = null)
    {
        // validation for constraint: string
        if (!is_null($nombreCompleto) && !is_string($nombreCompleto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombreCompleto)), __LINE__);
        }
        if (is_null($nombreCompleto) || (is_array($nombreCompleto) && empty($nombreCompleto))) {
            unset($this->nombreCompleto);
        } else {
            $this->nombreCompleto = $nombreCompleto;
        }
        return $this;
    }
    /**
     * Get rut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRut()
    {
        return isset($this->rut) ? $this->rut : null;
    }
    /**
     * Set rut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rut
     * @return \StructType\PolizaPersonaModel
     */
    public function setRut($rut = null)
    {
        // validation for constraint: string
        if (!is_null($rut) && !is_string($rut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rut)), __LINE__);
        }
        if (is_null($rut) || (is_array($rut) && empty($rut))) {
            unset($this->rut);
        } else {
            $this->rut = $rut;
        }
        return $this;
    }
    /**
     * Get sexo value
     * @return string|null
     */
    public function getSexo()
    {
        return $this->sexo;
    }
    /**
     * Set sexo value
     * @uses \EnumType\SexoEnum::valueIsValid()
     * @uses \EnumType\SexoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sexo
     * @return \StructType\PolizaPersonaModel
     */
    public function setSexo($sexo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SexoEnum::valueIsValid($sexo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sexo, implode(', ', \EnumType\SexoEnum::getValidValues())), __LINE__);
        }
        $this->sexo = $sexo;
        return $this;
    }
    /**
     * Get tipoPersona value
     * @return string|null
     */
    public function getTipoPersona()
    {
        return $this->tipoPersona;
    }
    /**
     * Set tipoPersona value
     * @uses \EnumType\TipoPersona::valueIsValid()
     * @uses \EnumType\TipoPersona::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPersona
     * @return \StructType\PolizaPersonaModel
     */
    public function setTipoPersona($tipoPersona = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoPersona::valueIsValid($tipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoPersona, implode(', ', \EnumType\TipoPersona::getValidValues())), __LINE__);
        }
        $this->tipoPersona = $tipoPersona;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolizaPersonaModel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
