<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opcionales StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Opcionales
 * @subpackage Structs
 */
class Opcionales extends AbstractStructBase
{
    /**
     * The autoReemplazo
     * @var string
     */
    public $autoReemplazo;
    /**
     * The rCExceso
     * @var string
     */
    public $rCExceso;
    /**
     * The taller
     * @var string
     */
    public $taller;
    /**
     * Constructor method for Opcionales
     * @uses Opcionales::setAutoReemplazo()
     * @uses Opcionales::setRCExceso()
     * @uses Opcionales::setTaller()
     * @param string $autoReemplazo
     * @param string $rCExceso
     * @param string $taller
     */
    public function __construct($autoReemplazo = null, $rCExceso = null, $taller = null)
    {
        $this
            ->setAutoReemplazo($autoReemplazo)
            ->setRCExceso($rCExceso)
            ->setTaller($taller);
    }
    /**
     * Get autoReemplazo value
     * @return string|null
     */
    public function getAutoReemplazo()
    {
        return $this->autoReemplazo;
    }
    /**
     * Set autoReemplazo value
     * @uses \EnumType\OpcionalAutoReemplazo::valueIsValid()
     * @uses \EnumType\OpcionalAutoReemplazo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoReemplazo
     * @return \StructType\Opcionales
     */
    public function setAutoReemplazo($autoReemplazo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OpcionalAutoReemplazo::valueIsValid($autoReemplazo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoReemplazo, implode(', ', \EnumType\OpcionalAutoReemplazo::getValidValues())), __LINE__);
        }
        $this->autoReemplazo = $autoReemplazo;
        return $this;
    }
    /**
     * Get rCExceso value
     * @return string|null
     */
    public function getRCExceso()
    {
        return $this->rCExceso;
    }
    /**
     * Set rCExceso value
     * @uses \EnumType\OpcionalRCExceso::valueIsValid()
     * @uses \EnumType\OpcionalRCExceso::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rCExceso
     * @return \StructType\Opcionales
     */
    public function setRCExceso($rCExceso = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OpcionalRCExceso::valueIsValid($rCExceso)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rCExceso, implode(', ', \EnumType\OpcionalRCExceso::getValidValues())), __LINE__);
        }
        $this->rCExceso = $rCExceso;
        return $this;
    }
    /**
     * Get taller value
     * @return string|null
     */
    public function getTaller()
    {
        return $this->taller;
    }
    /**
     * Set taller value
     * @uses \EnumType\OpcionalTaller::valueIsValid()
     * @uses \EnumType\OpcionalTaller::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taller
     * @return \StructType\Opcionales
     */
    public function setTaller($taller = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OpcionalTaller::valueIsValid($taller)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $taller, implode(', ', \EnumType\OpcionalTaller::getValidValues())), __LINE__);
        }
        $this->taller = $taller;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Opcionales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
