<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.segurossura.cl/AutoClickServicios/Services/WsIndustrializacion.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://test.segurossura.cl/AutoClickServicios/Services/WsIndustrializacion.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cotiza ServiceType
 */
$cotiza = new \ServiceType\Cotiza($options);
$cotiza->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for CotizaOfertaKilometros operation/method
 */
if ($cotiza->CotizaOfertaKilometros(new \StructType\CotizaOfertaRequest()) !== false) {
    print_r($cotiza->getResult());
} else {
    print_r($cotiza->getLastError());
}
/**
 * Sample call for CotizaOferta operation/method
 */
if ($cotiza->CotizaOferta(new \StructType\CotizaOfertaRequest()) !== false) {
    print_r($cotiza->getResult());
} else {
    print_r($cotiza->getLastError());
}
/**
 * Sample call for CotizaProducto operation/method
 */
if ($cotiza->CotizaProducto(new \StructType\CotizaProductoRequest()) !== false) {
    print_r($cotiza->getResult());
} else {
    print_r($cotiza->getLastError());
}
/**
 * Sample call for CotizaProductoBase operation/method
 */
if ($cotiza->CotizaProductoBase(new \StructType\CotizaProductoRequest()) !== false) {
    print_r($cotiza->getResult());
} else {
    print_r($cotiza->getLastError());
}
/**
 * Sample call for CotizaOfertaBase operation/method
 */
if ($cotiza->CotizaOfertaBase(new \StructType\CotizaOfertaRequest()) !== false) {
    print_r($cotiza->getResult());
} else {
    print_r($cotiza->getLastError());
}
/**
 * Sample call for CotizaOfertaBaseFalabella operation/method
 */
if ($cotiza->CotizaOfertaBaseFalabella(new \StructType\CotizaOfertaRequest()) !== false) {
    print_r($cotiza->getResult());
} else {
    print_r($cotiza->getLastError());
}
/**
 * Samples for Guarda ServiceType
 */
$guarda = new \ServiceType\Guarda($options);
$guarda->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for GuardaPolizaKilometros operation/method
 */
if ($guarda->GuardaPolizaKilometros(new \StructType\GuardaPolizaKilometrosRequest()) !== false) {
    print_r($guarda->getResult());
} else {
    print_r($guarda->getLastError());
}
/**
 * Samples for Cotizador ServiceType
 */
$cotizador = new \ServiceType\Cotizador($options);
$cotizador->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for CotizadorVehiculo operation/method
 */
if ($cotizador->CotizadorVehiculo(new \StructType\CotizadorVehiculoRequest()) !== false) {
    print_r($cotizador->getResult());
} else {
    print_r($cotizador->getLastError());
}
/**
 * Samples for Generar ServiceType
 */
$generar = new \ServiceType\Generar($options);
$generar->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for GenerarCotizacion operation/method
 */
if ($generar->GenerarCotizacion(new \StructType\GeneraCotizacionRequest()) !== false) {
    print_r($generar->getResult());
} else {
    print_r($generar->getLastError());
}
/**
 * Sample call for GenerarPoliza operation/method
 */
if ($generar->GenerarPoliza(new \StructType\GeneraPolizaRequest()) !== false) {
    print_r($generar->getResult());
} else {
    print_r($generar->getLastError());
}
/**
 * Sample call for GenerarPolizaHub operation/method
 */
if ($generar->GenerarPolizaHub(new \StructType\GeneraPolizaHubRequest()) !== false) {
    print_r($generar->getResult());
} else {
    print_r($generar->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ServiceType\Consulta($options);
$consulta->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for ConsultaEstadoCotizacion operation/method
 */
if ($consulta->ConsultaEstadoCotizacion(new \StructType\ConsultaEstadoCotizacionRequest()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaSiniestralidad operation/method
 */
if ($consulta->ConsultaSiniestralidad(new \StructType\ConsultaSiniestralidadRequest()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaPlanPago operation/method
 */
if ($consulta->ConsultaPlanPago(new \StructType\ConsultaPlanPagoRequest()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaContactabilidad operation/method
 */
if ($consulta->ConsultaContactabilidad(new \StructType\ConsultaContactabilidadRequest()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaDocumentos operation/method
 */
if ($consulta->ConsultaDocumentos(new \StructType\ConsultaDocumentosRequest()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaPolizaIndividual operation/method
 */
if ($consulta->ConsultaPolizaIndividual(new \StructType\ConsultaPolizaIndividual()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Samples for Genera ServiceType
 */
$genera = new \ServiceType\Genera($options);
$genera->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for GeneraPropuestaPoliza operation/method
 */
if ($genera->GeneraPropuestaPoliza(new \StructType\GeneraPropuestaPolizaRequest()) !== false) {
    print_r($genera->getResult());
} else {
    print_r($genera->getLastError());
}
/**
 * Samples for Formaliza ServiceType
 */
$formaliza = new \ServiceType\Formaliza($options);
$formaliza->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for FormalizaPoliza operation/method
 */
if ($formaliza->FormalizaPoliza(new \StructType\FormalizaPolizaRequest()) !== false) {
    print_r($formaliza->getResult());
} else {
    print_r($formaliza->getLastError());
}
/**
 * Samples for Venta ServiceType
 */
$venta = new \ServiceType\Venta($options);
$venta->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for VentaVehiculo operation/method
 */
if ($venta->VentaVehiculo(new \StructType\VentaVehiculoRequest()) !== false) {
    print_r($venta->getResult());
} else {
    print_r($venta->getLastError());
}
/**
 * Samples for Reimprime ServiceType
 */
$reimprime = new \ServiceType\Reimprime($options);
$reimprime->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for ReimprimePoliza operation/method
 */
if ($reimprime->ReimprimePoliza(new \StructType\ReimprimePolizaRequest()) !== false) {
    print_r($reimprime->getResult());
} else {
    print_r($reimprime->getLastError());
}
/**
 * Samples for Descuento ServiceType
 */
$descuento = new \ServiceType\Descuento($options);
$descuento->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for DescuentoRecargo operation/method
 */
if ($descuento->DescuentoRecargo(new \StructType\DescuentoRecargoCotizacionRequest()) !== false) {
    print_r($descuento->getResult());
} else {
    print_r($descuento->getLastError());
}
/**
 * Samples for Detalle ServiceType
 */
$detalle = new \ServiceType\Detalle($options);
$detalle->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for DetalleProducto operation/method
 */
if ($detalle->DetalleProducto(new \StructType\DetalleProductoRequest()) !== false) {
    print_r($detalle->getResult());
} else {
    print_r($detalle->getLastError());
}
/**
 * Samples for Solicitud ServiceType
 */
$solicitud = new \ServiceType\Solicitud($options);
$solicitud->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for SolicitudInspeccion operation/method
 */
if ($solicitud->SolicitudInspeccion(new \StructType\SolicitudInspeccionRequest()) !== false) {
    print_r($solicitud->getResult());
} else {
    print_r($solicitud->getLastError());
}
/**
 * Samples for Solicitar ServiceType
 */
$solicitar = new \ServiceType\Solicitar($options);
$solicitar->setSoapHeaderDatosTransaccion($DatosTransaccion);
/**
 * Sample call for SolicitarPoliza operation/method
 */
if ($solicitar->SolicitarPoliza(new \StructType\GeneraPolizaRequest()) !== false) {
    print_r($solicitar->getResult());
} else {
    print_r($solicitar->getLastError());
}
