<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolizaExternaPlanPagoPATModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PolizaExternaPlanPagoPATModel
 * @subpackage Structs
 */
class PolizaExternaPlanPagoPATModel extends AbstractStructBase
{
    /**
     * The anioVencimiento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $anioVencimiento;
    /**
     * The bancoID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bancoID;
    /**
     * The mesVencimiento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $mesVencimiento;
    /**
     * The numeroTarjeta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numeroTarjeta;
    /**
     * The tarjetaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $tarjetaID;
    /**
     * Constructor method for PolizaExternaPlanPagoPATModel
     * @uses PolizaExternaPlanPagoPATModel::setAnioVencimiento()
     * @uses PolizaExternaPlanPagoPATModel::setBancoID()
     * @uses PolizaExternaPlanPagoPATModel::setMesVencimiento()
     * @uses PolizaExternaPlanPagoPATModel::setNumeroTarjeta()
     * @uses PolizaExternaPlanPagoPATModel::setTarjetaID()
     * @param int $anioVencimiento
     * @param int $bancoID
     * @param int $mesVencimiento
     * @param string $numeroTarjeta
     * @param int $tarjetaID
     */
    public function __construct($anioVencimiento = null, $bancoID = null, $mesVencimiento = null, $numeroTarjeta = null, $tarjetaID = null)
    {
        $this
            ->setAnioVencimiento($anioVencimiento)
            ->setBancoID($bancoID)
            ->setMesVencimiento($mesVencimiento)
            ->setNumeroTarjeta($numeroTarjeta)
            ->setTarjetaID($tarjetaID);
    }
    /**
     * Get anioVencimiento value
     * @return int|null
     */
    public function getAnioVencimiento()
    {
        return $this->anioVencimiento;
    }
    /**
     * Set anioVencimiento value
     * @param int $anioVencimiento
     * @return \StructType\PolizaExternaPlanPagoPATModel
     */
    public function setAnioVencimiento($anioVencimiento = null)
    {
        // validation for constraint: int
        if (!is_null($anioVencimiento) && !(is_int($anioVencimiento) || ctype_digit($anioVencimiento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anioVencimiento, true), gettype($anioVencimiento)), __LINE__);
        }
        $this->anioVencimiento = $anioVencimiento;
        return $this;
    }
    /**
     * Get bancoID value
     * @return int|null
     */
    public function getBancoID()
    {
        return $this->bancoID;
    }
    /**
     * Set bancoID value
     * @param int $bancoID
     * @return \StructType\PolizaExternaPlanPagoPATModel
     */
    public function setBancoID($bancoID = null)
    {
        // validation for constraint: int
        if (!is_null($bancoID) && !(is_int($bancoID) || ctype_digit($bancoID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bancoID, true), gettype($bancoID)), __LINE__);
        }
        $this->bancoID = $bancoID;
        return $this;
    }
    /**
     * Get mesVencimiento value
     * @return int|null
     */
    public function getMesVencimiento()
    {
        return $this->mesVencimiento;
    }
    /**
     * Set mesVencimiento value
     * @param int $mesVencimiento
     * @return \StructType\PolizaExternaPlanPagoPATModel
     */
    public function setMesVencimiento($mesVencimiento = null)
    {
        // validation for constraint: int
        if (!is_null($mesVencimiento) && !(is_int($mesVencimiento) || ctype_digit($mesVencimiento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mesVencimiento, true), gettype($mesVencimiento)), __LINE__);
        }
        $this->mesVencimiento = $mesVencimiento;
        return $this;
    }
    /**
     * Get numeroTarjeta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroTarjeta()
    {
        return isset($this->numeroTarjeta) ? $this->numeroTarjeta : null;
    }
    /**
     * Set numeroTarjeta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroTarjeta
     * @return \StructType\PolizaExternaPlanPagoPATModel
     */
    public function setNumeroTarjeta($numeroTarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($numeroTarjeta) && !is_string($numeroTarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroTarjeta, true), gettype($numeroTarjeta)), __LINE__);
        }
        if (is_null($numeroTarjeta) || (is_array($numeroTarjeta) && empty($numeroTarjeta))) {
            unset($this->numeroTarjeta);
        } else {
            $this->numeroTarjeta = $numeroTarjeta;
        }
        return $this;
    }
    /**
     * Get tarjetaID value
     * @return int|null
     */
    public function getTarjetaID()
    {
        return $this->tarjetaID;
    }
    /**
     * Set tarjetaID value
     * @param int $tarjetaID
     * @return \StructType\PolizaExternaPlanPagoPATModel
     */
    public function setTarjetaID($tarjetaID = null)
    {
        // validation for constraint: int
        if (!is_null($tarjetaID) && !(is_int($tarjetaID) || ctype_digit($tarjetaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tarjetaID, true), gettype($tarjetaID)), __LINE__);
        }
        $this->tarjetaID = $tarjetaID;
        return $this;
    }
}
