<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanPagoCuotasModel StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PlanPagoCuotasModel
 * @subpackage Structs
 */
class PlanPagoCuotasModel extends AbstractStructBase
{
    /**
     * The FechaCuota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FechaCuota;
    /**
     * The NumeroCuota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroCuota;
    /**
     * The ValorCuota
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorCuota;
    /**
     * Constructor method for PlanPagoCuotasModel
     * @uses PlanPagoCuotasModel::setFechaCuota()
     * @uses PlanPagoCuotasModel::setNumeroCuota()
     * @uses PlanPagoCuotasModel::setValorCuota()
     * @param string $fechaCuota
     * @param int $numeroCuota
     * @param float $valorCuota
     */
    public function __construct($fechaCuota = null, $numeroCuota = null, $valorCuota = null)
    {
        $this
            ->setFechaCuota($fechaCuota)
            ->setNumeroCuota($numeroCuota)
            ->setValorCuota($valorCuota);
    }
    /**
     * Get FechaCuota value
     * @return string|null
     */
    public function getFechaCuota()
    {
        return $this->FechaCuota;
    }
    /**
     * Set FechaCuota value
     * @param string $fechaCuota
     * @return \StructType\PlanPagoCuotasModel
     */
    public function setFechaCuota($fechaCuota = null)
    {
        // validation for constraint: string
        if (!is_null($fechaCuota) && !is_string($fechaCuota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaCuota, true), gettype($fechaCuota)), __LINE__);
        }
        $this->FechaCuota = $fechaCuota;
        return $this;
    }
    /**
     * Get NumeroCuota value
     * @return int|null
     */
    public function getNumeroCuota()
    {
        return $this->NumeroCuota;
    }
    /**
     * Set NumeroCuota value
     * @param int $numeroCuota
     * @return \StructType\PlanPagoCuotasModel
     */
    public function setNumeroCuota($numeroCuota = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCuota) && !(is_int($numeroCuota) || ctype_digit($numeroCuota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroCuota, true), gettype($numeroCuota)), __LINE__);
        }
        $this->NumeroCuota = $numeroCuota;
        return $this;
    }
    /**
     * Get ValorCuota value
     * @return float|null
     */
    public function getValorCuota()
    {
        return $this->ValorCuota;
    }
    /**
     * Set ValorCuota value
     * @param float $valorCuota
     * @return \StructType\PlanPagoCuotasModel
     */
    public function setValorCuota($valorCuota = null)
    {
        // validation for constraint: float
        if (!is_null($valorCuota) && !(is_float($valorCuota) || is_numeric($valorCuota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorCuota, true), gettype($valorCuota)), __LINE__);
        }
        $this->ValorCuota = $valorCuota;
        return $this;
    }
}
