<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosBien StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DatosBien
 * @subpackage Structs
 */
class DatosBien extends AbstractStructBase
{
    /**
     * The anio
     * @var int
     */
    public $anio;
    /**
     * The codigoMarca
     * @var int
     */
    public $codigoMarca;
    /**
     * The codigoModelo
     * @var int
     */
    public $codigoModelo;
    /**
     * The esNuevo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $esNuevo;
    /**
     * The patente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $patente;
    /**
     * The usoBien
     * @var string
     */
    public $usoBien;
    /**
     * Constructor method for DatosBien
     * @uses DatosBien::setAnio()
     * @uses DatosBien::setCodigoMarca()
     * @uses DatosBien::setCodigoModelo()
     * @uses DatosBien::setEsNuevo()
     * @uses DatosBien::setPatente()
     * @uses DatosBien::setUsoBien()
     * @param int $anio
     * @param int $codigoMarca
     * @param int $codigoModelo
     * @param bool $esNuevo
     * @param string $patente
     * @param string $usoBien
     */
    public function __construct($anio = null, $codigoMarca = null, $codigoModelo = null, $esNuevo = null, $patente = null, $usoBien = null)
    {
        $this
            ->setAnio($anio)
            ->setCodigoMarca($codigoMarca)
            ->setCodigoModelo($codigoModelo)
            ->setEsNuevo($esNuevo)
            ->setPatente($patente)
            ->setUsoBien($usoBien);
    }
    /**
     * Get anio value
     * @return int|null
     */
    public function getAnio()
    {
        return $this->anio;
    }
    /**
     * Set anio value
     * @param int $anio
     * @return \StructType\DatosBien
     */
    public function setAnio($anio = null)
    {
        // validation for constraint: int
        if (!is_null($anio) && !(is_int($anio) || ctype_digit($anio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anio, true), gettype($anio)), __LINE__);
        }
        $this->anio = $anio;
        return $this;
    }
    /**
     * Get codigoMarca value
     * @return int|null
     */
    public function getCodigoMarca()
    {
        return $this->codigoMarca;
    }
    /**
     * Set codigoMarca value
     * @param int $codigoMarca
     * @return \StructType\DatosBien
     */
    public function setCodigoMarca($codigoMarca = null)
    {
        // validation for constraint: int
        if (!is_null($codigoMarca) && !(is_int($codigoMarca) || ctype_digit($codigoMarca))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoMarca, true), gettype($codigoMarca)), __LINE__);
        }
        $this->codigoMarca = $codigoMarca;
        return $this;
    }
    /**
     * Get codigoModelo value
     * @return int|null
     */
    public function getCodigoModelo()
    {
        return $this->codigoModelo;
    }
    /**
     * Set codigoModelo value
     * @param int $codigoModelo
     * @return \StructType\DatosBien
     */
    public function setCodigoModelo($codigoModelo = null)
    {
        // validation for constraint: int
        if (!is_null($codigoModelo) && !(is_int($codigoModelo) || ctype_digit($codigoModelo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoModelo, true), gettype($codigoModelo)), __LINE__);
        }
        $this->codigoModelo = $codigoModelo;
        return $this;
    }
    /**
     * Get esNuevo value
     * @return bool|null
     */
    public function getEsNuevo()
    {
        return $this->esNuevo;
    }
    /**
     * Set esNuevo value
     * @param bool $esNuevo
     * @return \StructType\DatosBien
     */
    public function setEsNuevo($esNuevo = null)
    {
        // validation for constraint: boolean
        if (!is_null($esNuevo) && !is_bool($esNuevo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esNuevo, true), gettype($esNuevo)), __LINE__);
        }
        $this->esNuevo = $esNuevo;
        return $this;
    }
    /**
     * Get patente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPatente()
    {
        return isset($this->patente) ? $this->patente : null;
    }
    /**
     * Set patente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $patente
     * @return \StructType\DatosBien
     */
    public function setPatente($patente = null)
    {
        // validation for constraint: string
        if (!is_null($patente) && !is_string($patente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patente, true), gettype($patente)), __LINE__);
        }
        if (is_null($patente) || (is_array($patente) && empty($patente))) {
            unset($this->patente);
        } else {
            $this->patente = $patente;
        }
        return $this;
    }
    /**
     * Get usoBien value
     * @return string|null
     */
    public function getUsoBien()
    {
        return $this->usoBien;
    }
    /**
     * Set usoBien value
     * @uses \EnumType\UsoBienEnum::valueIsValid()
     * @uses \EnumType\UsoBienEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usoBien
     * @return \StructType\DatosBien
     */
    public function setUsoBien($usoBien = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UsoBienEnum::valueIsValid($usoBien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UsoBienEnum', is_array($usoBien) ? implode(', ', $usoBien) : var_export($usoBien, true), implode(', ', \EnumType\UsoBienEnum::getValidValues())), __LINE__);
        }
        $this->usoBien = $usoBien;
        return $this;
    }
}
