<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCuota ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCuota
 * @subpackage Arrays
 */
class ArrayOfCuota extends AbstractStructArrayBase
{
    /**
     * The Cuota
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Cuota[]
     */
    public $Cuota;
    /**
     * Constructor method for ArrayOfCuota
     * @uses ArrayOfCuota::setCuota()
     * @param \StructType\Cuota[] $cuota
     */
    public function __construct(array $cuota = array())
    {
        $this
            ->setCuota($cuota);
    }
    /**
     * Get Cuota value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Cuota[]|null
     */
    public function getCuota()
    {
        return isset($this->Cuota) ? $this->Cuota : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCuota method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCuota method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCuotaForArrayConstraintsFromSetCuota(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCuotaCuotaItem) {
            // validation for constraint: itemType
            if (!$arrayOfCuotaCuotaItem instanceof \StructType\Cuota) {
                $invalidValues[] = is_object($arrayOfCuotaCuotaItem) ? get_class($arrayOfCuotaCuotaItem) : sprintf('%s(%s)', gettype($arrayOfCuotaCuotaItem), var_export($arrayOfCuotaCuotaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cuota property can only contain items of type \StructType\Cuota, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cuota value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Cuota[] $cuota
     * @return \ArrayType\ArrayOfCuota
     */
    public function setCuota(array $cuota = array())
    {
        // validation for constraint: array
        if ('' !== ($cuotaArrayErrorMessage = self::validateCuotaForArrayConstraintsFromSetCuota($cuota))) {
            throw new \InvalidArgumentException($cuotaArrayErrorMessage, __LINE__);
        }
        if (is_null($cuota) || (is_array($cuota) && empty($cuota))) {
            unset($this->Cuota);
        } else {
            $this->Cuota = $cuota;
        }
        return $this;
    }
    /**
     * Add item to Cuota value
     * @throws \InvalidArgumentException
     * @param \StructType\Cuota $item
     * @return \ArrayType\ArrayOfCuota
     */
    public function addToCuota(\StructType\Cuota $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Cuota) {
            throw new \InvalidArgumentException(sprintf('The Cuota property can only contain items of type \StructType\Cuota, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cuota[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Cuota|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Cuota|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Cuota|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Cuota|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Cuota|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cuota
     */
    public function getAttributeName()
    {
        return 'Cuota';
    }
}
