<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opcional StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Opcional
 * @subpackage Structs
 */
class Opcional extends AbstractStructBase
{
    /**
     * The OpcionalID
     * @var int
     */
    public $OpcionalID;
    /**
     * The descripcion
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $descripcion;
    /**
     * The prima
     * @var float
     */
    public $prima;
    /**
     * The factor
     * @var float
     */
    public $factor;
    /**
     * Constructor method for Opcional
     * @uses Opcional::setOpcionalID()
     * @uses Opcional::setDescripcion()
     * @uses Opcional::setPrima()
     * @uses Opcional::setFactor()
     * @param int $opcionalID
     * @param string $descripcion
     * @param float $prima
     * @param float $factor
     */
    public function __construct($opcionalID = null, $descripcion = null, $prima = null, $factor = null)
    {
        $this
            ->setOpcionalID($opcionalID)
            ->setDescripcion($descripcion)
            ->setPrima($prima)
            ->setFactor($factor);
    }
    /**
     * Get OpcionalID value
     * @return int|null
     */
    public function getOpcionalID()
    {
        return $this->OpcionalID;
    }
    /**
     * Set OpcionalID value
     * @param int $opcionalID
     * @return \StructType\Opcional
     */
    public function setOpcionalID($opcionalID = null)
    {
        // validation for constraint: int
        if (!is_null($opcionalID) && !(is_int($opcionalID) || ctype_digit($opcionalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($opcionalID, true), gettype($opcionalID)), __LINE__);
        }
        $this->OpcionalID = $opcionalID;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\Opcional
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Get prima value
     * @return float|null
     */
    public function getPrima()
    {
        return $this->prima;
    }
    /**
     * Set prima value
     * @param float $prima
     * @return \StructType\Opcional
     */
    public function setPrima($prima = null)
    {
        // validation for constraint: float
        if (!is_null($prima) && !(is_float($prima) || is_numeric($prima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prima, true), gettype($prima)), __LINE__);
        }
        $this->prima = $prima;
        return $this;
    }
    /**
     * Get factor value
     * @return float|null
     */
    public function getFactor()
    {
        return $this->factor;
    }
    /**
     * Set factor value
     * @param float $factor
     * @return \StructType\Opcional
     */
    public function setFactor($factor = null)
    {
        // validation for constraint: float
        if (!is_null($factor) && !(is_float($factor) || is_numeric($factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($factor, true), gettype($factor)), __LINE__);
        }
        $this->factor = $factor;
        return $this;
    }
}
