<?php

namespace Sura\Autoclick\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Formaliza ServiceType
 * @subpackage Services
 */
class Formaliza extends AbstractSoapClientBase
{
    /**
     * Sets the DatosTransaccion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sura\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderDatosTransaccion(\Sura\Autoclick\StructType\DatosTransaccionExterna $datosTransaccion, $nameSpace = 'http://ws.rsa.cl/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'DatosTransaccion', $datosTransaccion, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named FormalizaPoliza
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: DatosTransaccion
     * - SOAPHeaderNamespaces: http://ws.rsa.cl/
     * - SOAPHeaderTypes: \Sura\Autoclick\StructType\DatosTransaccionExterna
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sura\Autoclick\StructType\FormalizaPolizaRequest $parameters
     * @return \Sura\Autoclick\StructType\FormalizaPolizaResponse|bool
     */
    public function FormalizaPoliza(\Sura\Autoclick\StructType\FormalizaPolizaRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->FormalizaPoliza($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sura\Autoclick\StructType\FormalizaPolizaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
