<?php

namespace Sura\Autoclick\EnumType;

/**
 * This class stands for TipoPersona EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TipoPersona
 * @subpackage Enumerations
 */
class TipoPersona
{
    /**
     * Constant for value 'Natural'
     * @return string 'Natural'
     */
    const VALUE_NATURAL = 'Natural';
    /**
     * Constant for value 'RazonSocial'
     * @return string 'RazonSocial'
     */
    const VALUE_RAZON_SOCIAL = 'RazonSocial';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NATURAL
     * @uses self::VALUE_RAZON_SOCIAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NATURAL,
            self::VALUE_RAZON_SOCIAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
