<?php

namespace Sura\Autoclick\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFormaPago ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfFormaPago
 * @subpackage Arrays
 */
class ArrayOfFormaPago extends AbstractStructArrayBase
{
    /**
     * The FormaPago
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $FormaPago;
    /**
     * Constructor method for ArrayOfFormaPago
     * @uses ArrayOfFormaPago::setFormaPago()
     * @param string[] $formaPago
     */
    public function __construct(array $formaPago = array())
    {
        $this
            ->setFormaPago($formaPago);
    }
    /**
     * Get FormaPago value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getFormaPago()
    {
        return isset($this->FormaPago) ? $this->FormaPago : null;
    }
    /**
     * Set FormaPago value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Sura\Autoclick\EnumType\FormaPago::valueIsValid()
     * @uses \Sura\Autoclick\EnumType\FormaPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $formaPago
     * @return \Sura\Autoclick\ArrayType\ArrayOfFormaPago
     */
    public function setFormaPago(array $formaPago = array())
    {
        $invalidValues = array();
        foreach ($formaPago as $arrayOfFormaPagoFormaPagoItem) {
            if (!\Sura\Autoclick\EnumType\FormaPago::valueIsValid($arrayOfFormaPagoFormaPagoItem)) {
                $invalidValues[] = var_export($arrayOfFormaPagoFormaPagoItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \Sura\Autoclick\EnumType\FormaPago::getValidValues())), __LINE__);
        }
        if (is_null($formaPago) || (is_array($formaPago) && empty($formaPago))) {
            unset($this->FormaPago);
        } else {
            $this->FormaPago = $formaPago;
        }
        return $this;
    }
    /**
     * Add item to FormaPago value
     * @uses \Sura\Autoclick\EnumType\FormaPago::valueIsValid()
     * @uses \Sura\Autoclick\EnumType\FormaPago::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sura\Autoclick\ArrayType\ArrayOfFormaPago
     */
    public function addToFormaPago($item)
    {
        // validation for constraint: enumeration
        if (!\Sura\Autoclick\EnumType\FormaPago::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Sura\Autoclick\EnumType\FormaPago::getValidValues())), __LINE__);
        }
        $this->FormaPago[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \Sura\Autoclick\EnumType\FormaPago::valueIsValid()
     * @param string $item
     * @return \Sura\Autoclick\ArrayType\ArrayOfFormaPago
     */
    public function add($item)
    {
        if (!\Sura\Autoclick\EnumType\FormaPago::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Sura\Autoclick\EnumType\FormaPago::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FormaPago
     */
    public function getAttributeName()
    {
        return 'FormaPago';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Sura\Autoclick\ArrayType\ArrayOfFormaPago
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
